/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.StripedReentrantLocks;
import org.jetbrains.annotations.NotNull;

public class StripedLockIntObjectConcurrentHashMap<V> {
    private static final StripedReentrantLocks STRIPED_REENTRANT_LOCKS = StripedReentrantLocks.getInstance();
    private final byte lockIndex = (byte)STRIPED_REENTRANT_LOCKS.allocateLockIndex();
    protected volatile int count;
    protected int modCount;
    protected volatile IntHashEntry[] table;

    public StripedLockIntObjectConcurrentHashMap(int initialCapacity, float loadFactor) {
        int cap = StripedLockIntObjectConcurrentHashMap.getInitCap(initialCapacity, loadFactor);
        this.setTable(new IntHashEntry[cap]);
    }

    private static int getInitCap(int initialCapacity, float loadFactor) {
        int cap;
        if (loadFactor <= 0.0f || initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        for (cap = 1; cap < initialCapacity; cap <<= 1) {
        }
        return cap;
    }

    public StripedLockIntObjectConcurrentHashMap() {
        this(16, 0.75f);
    }

    public V put(int key, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/StripedLockIntObjectConcurrentHashMap.put must not be null");
        }
        return this.put(key, value, false);
    }

    public boolean remove(int key, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/StripedLockIntObjectConcurrentHashMap.remove must not be null");
        }
        return this.doRemove(key, value) != null;
    }

    private void lock() {
        STRIPED_REENTRANT_LOCKS.lock(this.lockIndex & 0xFF);
    }

    private void unlock() {
        STRIPED_REENTRANT_LOCKS.unlock(this.lockIndex & 0xFF);
    }

    private int threshold() {
        return (int)((float)this.table.length * 0.75f);
    }

    private void setTable(IntHashEntry[] newTable) {
        this.table = newTable;
    }

    private IntHashEntry<V> getFirst(int hash) {
        IntHashEntry[] tab = this.table;
        return tab[hash & tab.length - 1];
    }

    public V get(int key) {
        if (this.count != 0) {
            IntHashEntry<V> e = this.getFirst(key);
            while (e != null) {
                if (key == e.key) {
                    return e.value;
                }
                e = e.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V put(int key, @NotNull V value, boolean onlyIfAbsent) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/StripedLockIntObjectConcurrentHashMap.put must not be null");
        }
        this.lock();
        try {
            V oldValue;
            IntHashEntry first;
            int c = this.count;
            if (c++ > this.threshold()) {
                this.rehash();
            }
            IntHashEntry[] tab = this.table;
            int index = key & tab.length - 1;
            IntHashEntry e = first = tab[index];
            while (e != null && key != e.key) {
                e = e.next;
            }
            if (e != null) {
                oldValue = e.value;
                if (!onlyIfAbsent) {
                    e.value = value;
                }
            } else {
                oldValue = null;
                ++this.modCount;
                tab[index] = new IntHashEntry(key, first, value);
                this.count = c;
            }
            V v = oldValue;
            return v;
        }
        finally {
            this.unlock();
        }
    }

    private void rehash() {
        IntHashEntry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            return;
        }
        IntHashEntry[] newTable = new IntHashEntry[oldCapacity << 1];
        int sizeMask = newTable.length - 1;
        for (IntHashEntry intHashEntry : oldTable) {
            int k;
            if (intHashEntry == null) continue;
            IntHashEntry next = intHashEntry.next;
            int idx = intHashEntry.key & sizeMask;
            if (next == null) {
                newTable[idx] = intHashEntry;
                continue;
            }
            IntHashEntry lastRun = intHashEntry;
            int lastIdx = idx;
            IntHashEntry last = next;
            while (last != null) {
                k = last.key & sizeMask;
                if (k != lastIdx) {
                    lastIdx = k;
                    lastRun = last;
                }
                last = last.next;
            }
            newTable[lastIdx] = lastRun;
            IntHashEntry p = intHashEntry;
            while (p != lastRun) {
                k = p.key & sizeMask;
                IntHashEntry n = newTable[k];
                newTable[k] = new IntHashEntry(p.key, n, p.value);
                p = p.next;
            }
        }
        this.setTable(newTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V doRemove(int key, V value) {
        this.lock();
        try {
            IntHashEntry first;
            int c = this.count - 1;
            IntHashEntry[] tab = this.table;
            int index = key & tab.length - 1;
            IntHashEntry e = first = tab[index];
            while (e != null && key != e.key) {
                e = e.next;
            }
            V oldValue = null;
            if (e != null) {
                Object v = e.value;
                if (value == null || value.equals(v)) {
                    oldValue = v;
                    ++this.modCount;
                    IntHashEntry newFirst = e.next;
                    IntHashEntry p = first;
                    while (p != e) {
                        newFirst = new IntHashEntry(p.key, newFirst, p.value);
                        p = p.next;
                    }
                    tab[index] = newFirst;
                    this.count = c;
                }
            }
            V v = oldValue;
            return v;
        }
        finally {
            this.unlock();
        }
    }

    private static final class IntHashEntry<V> {
        final int key;
        @NotNull
        volatile V value;
        final IntHashEntry<V> next;

        IntHashEntry(int key, IntHashEntry<V> next, @NotNull V value) {
            if (value == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/StripedLockIntObjectConcurrentHashMap$IntHashEntry.<init> must not be null");
            }
            this.key = key;
            this.next = next;
            this.value = value;
        }
    }
}

