/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.WeakReferenceArray;
import java.util.AbstractList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class UnsafeWeakList<T>
extends AbstractList<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.containers.UnsafeWeakList");
    protected final WeakReferenceArray<T> myArray;
    private int myCompressCountdown;

    public UnsafeWeakList() {
        this(new WeakReferenceArray());
    }

    UnsafeWeakList(@NotNull WeakReferenceArray<T> array) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/UnsafeWeakList.<init> must not be null");
        }
        this.myCompressCountdown = 10;
        this.myArray = array;
    }

    @Override
    public T get(int index) {
        return this.myArray.get(index);
    }

    @Override
    public boolean add(T element) {
        this.tryReduceCapacity(-1);
        this.myArray.add(element);
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return super.contains(o);
    }

    @Override
    public void add(int index, T element) {
        this.tryReduceCapacity(-1);
        this.myArray.add(index, element);
    }

    @Override
    public T remove(int index) {
        this.tryReduceCapacity(-1);
        return this.myArray.remove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            this.myArray.remove(i);
        }
        this.tryReduceCapacity(-1);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        MyIterator myIterator = new MyIterator();
        if (myIterator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/UnsafeWeakList.iterator must not return null");
        }
        return myIterator;
    }

    @Override
    public int size() {
        return this.myArray.size();
    }

    private int tryReduceCapacity(int trackIndex) {
        ++this.modCount;
        if (this.canReduceCapacity()) {
            return this.myArray.reduceCapacity(trackIndex);
        }
        return this.probablyCompress(trackIndex);
    }

    private int probablyCompress(int trackIndex) {
        --this.myCompressCountdown;
        if (this.myCompressCountdown > 0) {
            return trackIndex;
        }
        int newIndex = this.myArray.compress(trackIndex);
        this.myCompressCountdown = this.myArray.size() + 10;
        return newIndex;
    }

    private boolean canReduceCapacity() {
        return 10 < this.myArray.getCapacity() && this.myArray.getCapacity() > this.myArray.getAliveCount() * 3;
    }

    static /* synthetic */ int access$000(UnsafeWeakList x0) {
        return x0.modCount;
    }

    protected class MyIterator
    implements Iterator<T> {
        private int myNextIndex = -1;
        private int myCurrentIndex = -1;
        private T myNextElement = null;
        private int myModCount = UnsafeWeakList.access$000(UnsafeWeakList.this);

        public MyIterator() {
            this.findNext();
        }

        protected void findNext() {
            this.myNextElement = null;
            while (this.myNextElement == null) {
                this.myNextIndex = UnsafeWeakList.this.myArray.nextValid(this.myNextIndex);
                if (this.myNextIndex >= UnsafeWeakList.this.myArray.size()) {
                    this.myNextIndex = -1;
                    this.myNextElement = null;
                    return;
                }
                this.myNextElement = UnsafeWeakList.this.myArray.get(this.myNextIndex);
            }
        }

        @Override
        public boolean hasNext() {
            return this.myNextElement != null;
        }

        @Override
        public T next() {
            if (UnsafeWeakList.this.modCount != this.myModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.myNextElement == null) {
                throw new NoSuchElementException();
            }
            Object element = this.myNextElement;
            this.myCurrentIndex = this.myNextIndex;
            this.findNext();
            return element;
        }

        @Override
        public void remove() {
            if (this.myCurrentIndex == -1) {
                throw new IllegalStateException();
            }
            UnsafeWeakList.this.myArray.remove(this.myCurrentIndex);
            int removedIndex = this.myCurrentIndex;
            int newIndex = UnsafeWeakList.this.tryReduceCapacity(this.myNextIndex);
            this.myCurrentIndex = -1;
            this.myModCount = UnsafeWeakList.this.modCount;
            if (!this.hasNext()) {
                return;
            }
            if (newIndex < 0) {
                LOG.error(" was: " + this.myNextIndex + " got: " + newIndex + " size: " + UnsafeWeakList.this.myArray.size() + " current: " + removedIndex);
            }
            this.myNextIndex = newIndex;
            LOG.assertTrue(UnsafeWeakList.this.myArray.get(this.myNextIndex) == this.myNextElement);
        }
    }
}

