/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.RefHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class WeakHashMap<K, V>
extends RefHashMap<K, V> {
    public WeakHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public WeakHashMap() {
    }

    @Override
    protected <T> RefHashMap.Key<T> createKey(@NotNull T k, ReferenceQueue<? super T> q) {
        if (k == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/WeakHashMap.createKey must not be null");
        }
        return new WeakKey(k, q);
    }

    private static class WeakKey<T>
    extends WeakReference<T>
    implements RefHashMap.Key<T> {
        private final int myHash;

        private WeakKey(@NotNull T k, ReferenceQueue<? super T> q) {
            if (k == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/WeakHashMap$WeakKey.<init> must not be null");
            }
            super(k, q);
            this.myHash = k.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RefHashMap.Key)) {
                return false;
            }
            Object t = this.get();
            Object u = ((RefHashMap.Key)o).get();
            return this.myHash == o.hashCode() && (t == u || Comparing.equal(t, u));
        }

        public int hashCode() {
            return this.myHash;
        }

        @NonNls
        public String toString() {
            Object t = this.get();
            return "WeakKey(" + t + ", " + this.myHash + ")";
        }
    }
}

