/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.StringRef;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataInputOutputUtil {
    public static StringRef readNAME(@NotNull DataInput record, @NotNull AbstractStringEnumerator nameStore) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/DataInputOutputUtil.readNAME must not be null");
        }
        if (nameStore == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/io/DataInputOutputUtil.readNAME must not be null");
        }
        return StringRef.fromStream(record, nameStore);
    }

    public static void writeNAME(@NotNull DataOutput record, @Nullable String name, @NotNull AbstractStringEnumerator nameStore) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/DataInputOutputUtil.writeNAME must not be null");
        }
        if (nameStore == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/io/DataInputOutputUtil.writeNAME must not be null");
        }
        int nameId = name != null ? nameStore.enumerate(name) : 0;
        DataInputOutputUtil.writeINT(record, nameId);
    }

    public static int readINT(@NotNull DataInput record) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/DataInputOutputUtil.readINT must not be null");
        }
        int val = record.readUnsignedByte();
        if (val < 192) {
            return val;
        }
        int res = val - 192;
        int sh = 6;
        while (true) {
            int next = record.readUnsignedByte();
            res |= (next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static void writeINT(@NotNull DataOutput record, int val) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/io/DataInputOutputUtil.writeINT must not be null");
        }
        if (0 <= val && val < 192) {
            record.writeByte(val);
        } else {
            record.writeByte(192 + (val & 0x3F));
            val >>>= 6;
            while (val >= 128) {
                record.writeByte(val & 0x7F | 0x80);
                val >>>= 7;
            }
            record.writeByte(val);
        }
    }
}

