/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics.rendering;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.Named;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.rendering.Renderer;
import org.jetbrains.jet.lang.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.jet.lang.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public class Renderers {
    public static final Renderer<Object> TO_STRING = new Renderer<Object>(){

        @Override
        @NotNull
        public String render(@NotNull Object element) {
            return element.toString();
        }

        public String toString() {
            return "TO_STRING";
        }
    };
    public static final Renderer<Object> NAME = new Renderer<Object>(){

        @Override
        @NotNull
        public String render(@NotNull Object element) {
            if (element instanceof Named) {
                return ((Named)element).getName().asString();
            }
            return element.toString();
        }
    };
    public static final Renderer<PsiElement> ELEMENT_TEXT = new Renderer<PsiElement>(){

        @Override
        @NotNull
        public String render(@NotNull PsiElement element) {
            return element.getText();
        }
    };
    public static final Renderer<JetClassOrObject> RENDER_CLASS_OR_OBJECT = new Renderer<JetClassOrObject>(){

        @Override
        @NotNull
        public String render(@NotNull JetClassOrObject classOrObject) {
            String name;
            String string = name = classOrObject.getName() != null ? " '" + classOrObject.getName() + "'" : "";
            if (classOrObject instanceof JetClass) {
                return "Class" + name;
            }
            return "Object" + name;
        }
    };
    public static final Renderer<JetType> RENDER_TYPE = new Renderer<JetType>(){

        @Override
        @NotNull
        public String render(@NotNull JetType type) {
            return DescriptorRenderer.TEXT.renderType(type);
        }
    };
    public static final Renderer<Collection<? extends ResolvedCall<?>>> AMBIGUOUS_CALLS = new Renderer<Collection<? extends ResolvedCall<? extends CallableDescriptor>>>(){

        @Override
        @NotNull
        public String render(@NotNull Collection<? extends ResolvedCall<? extends CallableDescriptor>> argument) {
            StringBuilder stringBuilder = new StringBuilder("\n");
            for (ResolvedCall<? extends CallableDescriptor> resolvedCall : argument) {
                stringBuilder.append(DescriptorRenderer.TEXT.render(resolvedCall.getResultingDescriptor())).append("\n");
            }
            return stringBuilder.toString();
        }
    };
    public static final Renderer<InferenceErrorData.ExtendedInferenceErrorData> TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER = new Renderer<InferenceErrorData.ExtendedInferenceErrorData>(){

        @Override
        @NotNull
        public String render(@NotNull InferenceErrorData.ExtendedInferenceErrorData inferenceErrorData) {
            return Renderers.renderConflictingSubstitutionsInferenceError(inferenceErrorData, TabledDescriptorRenderer.create()).toString();
        }
    };
    public static final Renderer<InferenceErrorData.ExtendedInferenceErrorData> TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER = new Renderer<InferenceErrorData.ExtendedInferenceErrorData>(){

        @Override
        @NotNull
        public String render(@NotNull InferenceErrorData.ExtendedInferenceErrorData inferenceErrorData) {
            return Renderers.renderTypeConstructorMismatchError(inferenceErrorData, TabledDescriptorRenderer.create()).toString();
        }
    };
    public static final Renderer<InferenceErrorData.ExtendedInferenceErrorData> TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER = new Renderer<InferenceErrorData.ExtendedInferenceErrorData>(){

        @Override
        @NotNull
        public String render(@NotNull InferenceErrorData.ExtendedInferenceErrorData inferenceErrorData) {
            return Renderers.renderNoInformationForParameterError(inferenceErrorData, TabledDescriptorRenderer.create()).toString();
        }
    };
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER = new Renderer<InferenceErrorData>(){

        @Override
        @NotNull
        public String render(@NotNull InferenceErrorData inferenceErrorData) {
            return Renderers.renderUpperBoundViolatedInferenceError(inferenceErrorData, TabledDescriptorRenderer.create()).toString();
        }
    };
    public static final Renderer<Collection<ClassDescriptor>> CLASSES_OR_SEPARATED = new Renderer<Collection<ClassDescriptor>>(){

        @Override
        @NotNull
        public String render(@NotNull Collection<ClassDescriptor> descriptors) {
            StringBuilder sb = new StringBuilder();
            int index = 0;
            for (ClassDescriptor descriptor : descriptors) {
                sb.append(DescriptorUtils.getFQName(descriptor).asString());
                if (++index <= descriptors.size() - 2) {
                    sb.append(", ");
                    continue;
                }
                if (index != descriptors.size() - 1) continue;
                sb.append(" or ");
            }
            return sb.toString();
        }
    };
    public static final Renderer<Collection<JetType>> RENDER_COLLECTION_OF_TYPES = new Renderer<Collection<JetType>>(){

        @Override
        @NotNull
        public String render(@NotNull Collection<JetType> types) {
            return StringUtil.join(types, new Function<JetType, String>(){

                @Override
                public String fun(JetType type) {
                    return RENDER_TYPE.render(type);
                }
            }, ", ");
        }
    };

    public static <T> Renderer<Collection<? extends T>> commaSeparated(final Renderer<T> itemRenderer) {
        return new Renderer<Collection<? extends T>>(){

            @Override
            @NotNull
            public String render(@NotNull Collection<? extends T> object) {
                StringBuilder result = new StringBuilder();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    result.append(itemRenderer.render(next));
                    if (!iterator.hasNext()) continue;
                    result.append(", ");
                }
                return result.toString();
            }
        };
    }

    public static TabledDescriptorRenderer renderConflictingSubstitutionsInferenceError(InferenceErrorData.ExtendedInferenceErrorData inferenceErrorData, TabledDescriptorRenderer result) {
        assert (inferenceErrorData.constraintSystem.hasConflictingConstraints());
        ArrayList<CallableDescriptor> substitutedDescriptors = Lists.newArrayList();
        Collection<TypeSubstitutor> substitutors = ConstraintsUtil.getSubstitutorsForConflictingParameters(inferenceErrorData.constraintSystem);
        for (TypeSubstitutor substitutor : substitutors) {
            CallableDescriptor substitutedDescriptor = inferenceErrorData.descriptor.substitute(substitutor);
            substitutedDescriptors.add(substitutedDescriptor);
        }
        TypeParameterDescriptor firstConflictingParameter = ConstraintsUtil.getFirstConflictingParameter(inferenceErrorData.constraintSystem);
        assert (firstConflictingParameter != null);
        result.text(TabledDescriptorRenderer.newText().normal("Cannot infer type parameter ").strong(firstConflictingParameter.getName()).normal(" in "));
        TabledDescriptorRenderer.TableRenderer table = TabledDescriptorRenderer.newTable();
        result.table(table);
        table.descriptor(inferenceErrorData.descriptor).text("None of the following substitutions");
        for (CallableDescriptor substitutedDescriptor : substitutedDescriptors) {
            JetType receiverType = DescriptorUtils.getReceiverParameterType(substitutedDescriptor.getReceiverParameter());
            final HashSet<ConstraintPosition> errorPositions = Sets.newHashSet();
            ArrayList<JetType> parameterTypes = Lists.newArrayList();
            for (ValueParameterDescriptor valueParameterDescriptor : substitutedDescriptor.getValueParameters()) {
                JetType actualType;
                parameterTypes.add(valueParameterDescriptor.getType());
                if (valueParameterDescriptor.getIndex() >= inferenceErrorData.valueArgumentsTypes.size() || JetTypeChecker.INSTANCE.isSubtypeOf(actualType = inferenceErrorData.valueArgumentsTypes.get(valueParameterDescriptor.getIndex()), valueParameterDescriptor.getType())) continue;
                errorPositions.add(ConstraintPosition.getValueParameterPosition(valueParameterDescriptor.getIndex()));
            }
            if (receiverType != null && inferenceErrorData.receiverArgumentType != null && !JetTypeChecker.INSTANCE.isSubtypeOf(inferenceErrorData.receiverArgumentType, receiverType)) {
                errorPositions.add(ConstraintPosition.RECEIVER_POSITION);
            }
            Predicate<ConstraintPosition> isErrorPosition = new Predicate<ConstraintPosition>(){

                @Override
                public boolean apply(@Nullable ConstraintPosition constraintPosition) {
                    return errorPositions.contains(constraintPosition);
                }
            };
            table.functionArgumentTypeList(receiverType, parameterTypes, isErrorPosition);
        }
        table.text("can be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes);
        return result;
    }

    public static TabledDescriptorRenderer renderTypeConstructorMismatchError(final InferenceErrorData.ExtendedInferenceErrorData inferenceErrorData, TabledDescriptorRenderer renderer) {
        Predicate<ConstraintPosition> isErrorPosition = new Predicate<ConstraintPosition>(){

            @Override
            public boolean apply(@Nullable ConstraintPosition constraintPosition) {
                assert (constraintPosition != null);
                return inferenceErrorData.constraintSystem.hasTypeConstructorMismatchAt(constraintPosition);
            }
        };
        return renderer.table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("cannot be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes, isErrorPosition));
    }

    public static TabledDescriptorRenderer renderNoInformationForParameterError(InferenceErrorData.ExtendedInferenceErrorData inferenceErrorData, TabledDescriptorRenderer renderer) {
        Named firstUnknownParameter = null;
        for (TypeParameterDescriptor typeParameter : inferenceErrorData.constraintSystem.getTypeVariables()) {
            if (!inferenceErrorData.constraintSystem.getTypeConstraints(typeParameter).isEmpty()) continue;
            firstUnknownParameter = typeParameter;
            break;
        }
        assert (firstUnknownParameter != null);
        return renderer.text(TabledDescriptorRenderer.newText().normal("Not enough information to infer parameter ").strong(firstUnknownParameter.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("Please specify it explicitly."));
    }

    public static TabledDescriptorRenderer renderUpperBoundViolatedInferenceError(InferenceErrorData inferenceErrorData, TabledDescriptorRenderer result) {
        Named typeParameterDescriptor = null;
        for (TypeParameterDescriptor typeParameter : inferenceErrorData.descriptor.getTypeParameters()) {
            if (ConstraintsUtil.checkUpperBoundIsSatisfied(inferenceErrorData.constraintSystem, typeParameter, true)) continue;
            typeParameterDescriptor = typeParameter;
            break;
        }
        assert (typeParameterDescriptor != null);
        result.text(TabledDescriptorRenderer.newText().normal("Type parameter bound for ").strong(typeParameterDescriptor.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor));
        JetType inferredValueForTypeParameter = ConstraintsUtil.getValue(inferenceErrorData.constraintSystem.getTypeConstraints((TypeParameterDescriptor)typeParameterDescriptor));
        assert (inferredValueForTypeParameter != null);
        JetType upperBound = typeParameterDescriptor.getUpperBoundsAsType();
        JetType upperBoundWithSubstitutedInferredTypes = inferenceErrorData.constraintSystem.getResultingSubstitutor().substitute(upperBound, Variance.INVARIANT);
        assert (upperBoundWithSubstitutedInferredTypes != null);
        Renderer<JetType> typeRenderer = result.getTypeRenderer();
        result.text(TabledDescriptorRenderer.newText().normal(" is not satisfied: inferred type ").error(typeRenderer.render(inferredValueForTypeParameter)).normal(" is not a subtype of ").strong(typeRenderer.render(upperBoundWithSubstitutedInferredTypes)));
        return result;
    }

    private Renderers() {
    }
}

