/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.provider;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.provider.ClassPsiDeclarationProvider;
import org.jetbrains.jet.lang.resolve.java.provider.ClassPsiDeclarationProviderImpl;
import org.jetbrains.jet.lang.resolve.java.provider.KotlinNamespacePsiDeclarationProvider;
import org.jetbrains.jet.lang.resolve.java.provider.PackagePsiDeclarationProvider;
import org.jetbrains.jet.lang.resolve.java.provider.PackagePsiDeclarationProviderImpl;

public final class PsiDeclarationProviderFactory {
    @NotNull
    private final PsiClassFinder psiClassFinder;

    public PsiDeclarationProviderFactory(@NotNull PsiClassFinder psiClassFinder) {
        this.psiClassFinder = psiClassFinder;
    }

    @NotNull
    public ClassPsiDeclarationProvider createSyntheticClassObjectClassData(@NotNull PsiClass psiClass) {
        return this.createDeclarationProviderForClassStaticMembers(psiClass);
    }

    @NotNull
    public ClassPsiDeclarationProvider createBinaryClassData(@NotNull PsiClass psiClass) {
        return new ClassPsiDeclarationProviderImpl(psiClass, false, this.psiClassFinder);
    }

    @NotNull
    public KotlinNamespacePsiDeclarationProvider createDeclarationForKotlinNamespace(@NotNull PsiPackage psiPackage, @NotNull PsiClass psiClass) {
        return new KotlinNamespacePsiDeclarationProvider(psiPackage, psiClass, this.psiClassFinder);
    }

    @NotNull
    public PackagePsiDeclarationProvider createDeclarationProviderForNamespaceWithoutMembers(@NotNull PsiPackage psiPackage) {
        return new PackagePsiDeclarationProviderImpl(psiPackage, this.psiClassFinder);
    }

    @NotNull
    public ClassPsiDeclarationProvider createDeclarationProviderForClassStaticMembers(@NotNull PsiClass psiClass) {
        return new ClassPsiDeclarationProviderImpl(psiClass, true, this.psiClassFinder);
    }
}

