/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.provider.ClassPsiDeclarationProvider;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassMembersScope;

public final class JavaClassNonStaticMembersScope
extends JavaClassMembersScope {
    private Collection<ConstructorDescriptor> constructors = null;
    private ConstructorDescriptor primaryConstructor = null;
    @NotNull
    private final ClassDescriptor descriptor;

    public JavaClassNonStaticMembersScope(@NotNull ClassDescriptor descriptor, @NotNull ClassPsiDeclarationProvider psiDeclarationProvider, @NotNull JavaSemanticServices semanticServices) {
        super((ClassOrNamespaceDescriptor)descriptor, psiDeclarationProvider, semanticServices);
        this.descriptor = descriptor;
    }

    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        this.initConstructorsIfNeeded();
        return this.constructors;
    }

    @Nullable
    public ConstructorDescriptor getPrimaryConstructor() {
        this.initConstructorsIfNeeded();
        return this.primaryConstructor;
    }

    private void initConstructorsIfNeeded() {
        if (this.constructors == null) {
            this.constructors = this.getResolver().resolveConstructors(this.declarationProvider, this.descriptor);
            for (ConstructorDescriptor constructor : this.constructors) {
                if (!constructor.isPrimary()) continue;
                if (this.primaryConstructor != null) {
                    throw new IllegalStateException("Class has more than one primary constructor: " + this.primaryConstructor + "\n" + constructor);
                }
                this.primaryConstructor = constructor;
            }
        }
    }
}

