/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.wrapper;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.TypeSource;
import org.jetbrains.jet.lang.resolve.java.wrapper.PropertyPsiDataElement;

public final class PropertyPsiData {
    @Nullable
    private PropertyPsiDataElement getter = null;
    @Nullable
    private PropertyPsiDataElement setter = null;
    @Nullable
    private PropertyPsiDataElement field = null;
    @Nullable
    private Collection<PropertyPsiDataElement> elements = null;

    @NotNull
    public static Collection<PropertyPsiData> assemblePropertyPsiDataFromElements(@NotNull List<PropertyPsiDataElement> elements) {
        HashMap<String, PropertyPsiData> map = new HashMap<String, PropertyPsiData>();
        for (PropertyPsiDataElement element : elements) {
            String key = PropertyPsiData.propertyKeyForGrouping(element);
            PropertyPsiData value = (PropertyPsiData)map.get(key);
            if (value == null) {
                value = new PropertyPsiData();
                map.put(key, value);
            }
            if (element.isGetter()) {
                PropertyPsiData.checkDuplicatePropertyComponent(element, "getter", value.getter);
                value.getter = element;
                continue;
            }
            if (element.isSetter()) {
                PropertyPsiData.checkDuplicatePropertyComponent(element, "setter", value.setter);
                value.setter = element;
                continue;
            }
            if (element.isField()) {
                PropertyPsiData.checkDuplicatePropertyComponent(element, "field", value.field);
                value.field = element;
                continue;
            }
            throw new IllegalStateException();
        }
        return map.values();
    }

    private static void checkDuplicatePropertyComponent(@NotNull PropertyPsiDataElement checked, @NotNull String componentTypeName, @Nullable PropertyPsiDataElement existent) {
        if (existent != null) {
            PsiClass checkedElementClass = checked.getMember().getPsiMember().getContainingClass();
            PsiClass existentElementClass = existent.getMember().getPsiMember().getContainingClass();
            throw new IllegalStateException(String.format("Psi element '%s' in class '%s' overwrites '%s' in class '%s' while generating %s component for property", checked.getMember().getPsiMember(), checkedElementClass != null ? checkedElementClass.getQualifiedName() : "<no-class>", existent.getMember().getPsiMember(), existentElementClass != null ? existentElementClass.getQualifiedName() : "<no-class>", componentTypeName));
        }
    }

    @NotNull
    private static String propertyKeyForGrouping(@NotNull PropertyPsiDataElement propertyAccessor) {
        String type = PropertyPsiData.key(propertyAccessor.getType());
        String receiverType = PropertyPsiData.key(propertyAccessor.getReceiverType());
        return Pair.create(type, receiverType).toString();
    }

    @NotNull
    private static String key(@Nullable TypeSource typeSource) {
        if (typeSource == null) {
            return "";
        }
        if (typeSource.getTypeString().length() > 0) {
            return typeSource.getTypeString();
        }
        return typeSource.getPsiType().getPresentableText();
    }

    @Nullable
    public PropertyPsiDataElement getGetter() {
        return this.getter;
    }

    @Nullable
    public PropertyPsiDataElement getSetter() {
        return this.setter;
    }

    @NotNull
    private Collection<PropertyPsiDataElement> getElements() {
        if (this.elements == null) {
            this.elements = Lists.newArrayList();
            if (this.getter != null) {
                this.elements.add(this.getter);
            }
            if (this.setter != null) {
                this.elements.add(this.setter);
            }
            if (this.field != null) {
                this.elements.add(this.field);
            }
            assert (!this.elements.isEmpty());
        }
        return this.elements;
    }

    public boolean isExtension() {
        boolean isExtension = this.getCharacteristicMember().isExtension();
        for (PropertyPsiDataElement element : this.getElements()) {
            assert (element.isExtension() == isExtension);
        }
        return isExtension;
    }

    public boolean isStatic() {
        boolean isStatic = this.getCharacteristicMember().getMember().isStatic();
        for (PropertyPsiDataElement element : this.getElements()) {
            assert (element.getMember().isStatic() == isStatic);
        }
        return isStatic;
    }

    @NotNull
    public PropertyPsiDataElement getCharacteristicMember() {
        if (this.getter != null) {
            return this.getter;
        }
        if (this.field != null) {
            return this.field;
        }
        if (this.setter != null) {
            return this.setter;
        }
        throw new IllegalStateException();
    }

    @NotNull
    public PsiMember getCharacteristicPsi() {
        return this.getCharacteristicMember().getMember().getPsiMember();
    }

    public boolean isVar() {
        if (this.getter == null && this.setter == null) {
            assert (this.field != null);
            return !this.field.getMember().isFinal();
        }
        return this.setter != null;
    }

    public boolean isStaticFinalField() {
        if (this.getter != null || this.setter != null) {
            return false;
        }
        assert (this.field != null);
        return this.field.getMember().isFinal() && this.field.getMember().isStatic();
    }

    public boolean isPropertyForNamedObject() {
        return this.field != null && "instance$".equals(this.field.getMember().getName());
    }

    public boolean isFinal() {
        if (this.getter != null) {
            return this.getter.getMember().isFinal();
        }
        if (this.setter != null) {
            return this.setter.getMember().isFinal();
        }
        return false;
    }
}

