/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.google.common.collect.Maps;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;

public class AliasingContext {
    private static final AliasingContext ROOT = new AliasingContext(null){

        @Override
        public JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor) {
            return null;
        }

        @Override
        public JsName getAliasForExpression(@NotNull JetExpression element) {
            return null;
        }
    };
    @Nullable
    private Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors;
    @NotNull
    private final Map<JetExpression, JsName> aliasesForExpressions = Maps.newHashMap();
    @Nullable
    private final AliasingContext parent;

    public static AliasingContext getCleanContext() {
        return new AliasingContext(ROOT);
    }

    private AliasingContext(@Nullable AliasingContext parent) {
        this(parent, (Map<DeclarationDescriptor, JsExpression>)null);
    }

    private AliasingContext(@Nullable AliasingContext parent, @Nullable Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors) {
        this.parent = parent;
        this.aliasesForDescriptors = aliasesForDescriptors;
    }

    @NotNull
    public AliasingContext inner(@NotNull DeclarationDescriptor descriptor, @NotNull JsExpression alias) {
        return new AliasingContext(this, Collections.singletonMap(descriptor, alias));
    }

    @NotNull
    public AliasingContext withAliasesForExpressions(@NotNull Map<JetExpression, JsName> aliasesForExpressions) {
        AliasingContext newContext = new AliasingContext(this);
        newContext.aliasesForExpressions.putAll(aliasesForExpressions);
        return newContext;
    }

    @NotNull
    public AliasingContext withDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsExpression> aliases) {
        return new AliasingContext(this, aliases);
    }

    @Nullable
    public JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (this.aliasesForDescriptors == null) {
            return null;
        }
        JsExpression alias = this.aliasesForDescriptors.get(descriptor.getOriginal());
        if (alias != null) {
            return alias;
        }
        return this.parent.getAliasForDescriptor(descriptor);
    }

    @Nullable
    public JsName getAliasForExpression(@NotNull JetExpression element) {
        JsName alias = this.aliasesForExpressions.get(element);
        return alias != null ? alias : this.parent.getAliasForExpression(element);
    }

    public void registerAlias(@NotNull DeclarationDescriptor descriptor, @NotNull JsExpression alias) {
        if (this.aliasesForDescriptors == null) {
            this.aliasesForDescriptors = Collections.singletonMap(descriptor, alias);
        } else {
            if (this.aliasesForDescriptors.size() == 1) {
                Map<DeclarationDescriptor, JsExpression> singletonMap = this.aliasesForDescriptors;
                this.aliasesForDescriptors = new HashMap<DeclarationDescriptor, JsExpression>();
                this.aliasesForDescriptors.put(singletonMap.keySet().iterator().next(), singletonMap.values().iterator().next());
            }
            JsExpression prev = this.aliasesForDescriptors.put(descriptor, alias);
            assert (prev == null);
        }
    }
}

