/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.factories;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.util.AstUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.BuiltInPropertyIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.CompositeFIF;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.DescriptorPredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.PatternBuilder;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class StringOperationFIF
extends CompositeFIF {
    @NotNull
    private static final DescriptorPredicate GET_PATTERN = PatternBuilder.pattern("String.get");
    @NotNull
    private static final FunctionIntrinsic GET_INTRINSIC = new FunctionIntrinsic(){

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
            assert (receiver != null);
            assert (arguments.size() == 1) : "String#get expression must have 1 argument.";
            JsNameRef charAtReference = AstUtil.newQualifiedNameRef("charAt");
            JsAstUtils.setQualifier(charAtReference, receiver);
            return new JsInvocation((JsExpression)charAtReference, arguments);
        }
    };
    @NotNull
    public static final FunctionIntrinsicFactory INSTANCE = new StringOperationFIF();

    private StringOperationFIF() {
        this.add(GET_PATTERN, GET_INTRINSIC);
        this.add(PatternBuilder.pattern("String.<get-length>"), new BuiltInPropertyIntrinsic("length"));
        this.add(PatternBuilder.pattern("CharSequence.<get-length>"), new BuiltInPropertyIntrinsic("length"));
    }
}

