/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.RegularImmutableBiMap;
import java.util.Map;

public abstract class ImmutableBiMap<K, V>
extends ImmutableMap<K, V>
implements BiMap<K, V> {
    private static final ImmutableBiMap<Object, Object> EMPTY_IMMUTABLE_BIMAP = new EmptyBiMap();

    public static <K, V> ImmutableBiMap<K, V> of() {
        return EMPTY_IMMUTABLE_BIMAP;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    ImmutableBiMap() {
    }

    abstract ImmutableMap<K, V> delegate();

    public abstract ImmutableBiMap<V, K> inverse();

    @Override
    public boolean containsKey(Object key) {
        return this.delegate().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inverse().containsKey(value);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return this.delegate().entrySet();
    }

    @Override
    public V get(Object key) {
        return this.delegate().get(key);
    }

    @Override
    public ImmutableSet<K> keySet() {
        return this.delegate().keySet();
    }

    @Override
    public ImmutableSet<V> values() {
        return this.inverse().keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    @Override
    public int size() {
        return this.delegate().size();
    }

    @Override
    public boolean equals(Object object) {
        return object == this || this.delegate().equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    public String toString() {
        return this.delegate().toString();
    }

    static class EmptyBiMap
    extends ImmutableBiMap<Object, Object> {
        EmptyBiMap() {
        }

        @Override
        ImmutableMap<Object, Object> delegate() {
            return ImmutableMap.of();
        }

        @Override
        public ImmutableBiMap<Object, Object> inverse() {
            return this;
        }

        @Override
        boolean isPartialView() {
            return false;
        }
    }

    public static final class Builder<K, V>
    extends ImmutableMap.Builder<K, V> {
        @Override
        public Builder<K, V> put(K key, V value) {
            super.put(key, value);
            return this;
        }

        @Override
        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            super.putAll(map);
            return this;
        }

        @Override
        public ImmutableBiMap<K, V> build() {
            ImmutableMap map = super.build();
            if (map.isEmpty()) {
                return ImmutableBiMap.of();
            }
            return new RegularImmutableBiMap(map);
        }
    }
}

