/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.AbstractSetMultimap;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class LinkedHashMultimap<K, V>
extends AbstractSetMultimap<K, V> {
    transient int expectedValuesPerKey = 8;
    transient Collection<Map.Entry<K, V>> linkedEntries = Sets.newLinkedHashSet();

    public static <K, V> LinkedHashMultimap<K, V> create() {
        return new LinkedHashMultimap<K, V>();
    }

    private LinkedHashMultimap() {
        super(new LinkedHashMap());
    }

    @Override
    Set<V> createCollection() {
        return new LinkedHashSet(Maps.capacity(this.expectedValuesPerKey));
    }

    @Override
    Collection<V> createCollection(K key) {
        return new SetDecorator(key, this.createCollection());
    }

    @Override
    Iterator<Map.Entry<K, V>> createEntryIterator() {
        final Iterator<Map.Entry<K, V>> delegateIterator = this.linkedEntries.iterator();
        return new Iterator<Map.Entry<K, V>>(){
            Map.Entry<K, V> entry;

            @Override
            public boolean hasNext() {
                return delegateIterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.entry = (Map.Entry)delegateIterator.next();
                return this.entry;
            }

            @Override
            public void remove() {
                delegateIterator.remove();
                LinkedHashMultimap.this.remove(this.entry.getKey(), this.entry.getValue());
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return super.entries();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    private class SetDecorator
    extends ForwardingSet<V> {
        final Set<V> delegate;
        final K key;

        SetDecorator(K key, Set<V> delegate) {
            this.delegate = delegate;
            this.key = key;
        }

        @Override
        protected Set<V> delegate() {
            return this.delegate;
        }

        <E> Map.Entry<K, E> createEntry(E value) {
            return Maps.immutableEntry(this.key, value);
        }

        <E> Collection<Map.Entry<K, E>> createEntries(Collection<E> values) {
            ArrayList entries = Lists.newArrayListWithExpectedSize(values.size());
            for (E value : values) {
                entries.add(this.createEntry(value));
            }
            return entries;
        }

        @Override
        public boolean add(V value) {
            boolean changed = this.delegate.add(value);
            if (changed) {
                LinkedHashMultimap.this.linkedEntries.add(this.createEntry(value));
            }
            return changed;
        }

        @Override
        public boolean addAll(Collection<? extends V> values) {
            boolean changed = this.delegate.addAll(values);
            if (changed) {
                LinkedHashMultimap.this.linkedEntries.addAll(this.createEntries(this.delegate()));
            }
            return changed;
        }

        @Override
        public void clear() {
            for (Object value : this.delegate) {
                LinkedHashMultimap.this.linkedEntries.remove(this.createEntry(value));
            }
            this.delegate.clear();
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator delegateIterator = this.delegate.iterator();
            return new Iterator<V>(){
                V value;

                @Override
                public boolean hasNext() {
                    return delegateIterator.hasNext();
                }

                @Override
                public V next() {
                    this.value = delegateIterator.next();
                    return this.value;
                }

                @Override
                public void remove() {
                    delegateIterator.remove();
                    LinkedHashMultimap.this.linkedEntries.remove(SetDecorator.this.createEntry(this.value));
                }
            };
        }

        @Override
        public boolean remove(Object value) {
            boolean changed = this.delegate.remove(value);
            if (changed) {
                LinkedHashMultimap.this.linkedEntries.remove(this.createEntry(value));
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> values) {
            boolean changed = this.delegate.removeAll(values);
            if (changed) {
                LinkedHashMultimap.this.linkedEntries.removeAll(this.createEntries(values));
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> values) {
            boolean changed = false;
            Iterator iterator = this.delegate.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (values.contains(value)) continue;
                iterator.remove();
                LinkedHashMultimap.this.linkedEntries.remove(Maps.immutableEntry(this.key, value));
                changed = true;
            }
            return changed;
        }
    }
}

