/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.HasArguments;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class JsInvocation
extends JsExpressionImpl
implements HasArguments {
    private final List<JsExpression> arguments;
    private JsExpression qualifier;

    public JsInvocation() {
        this.arguments = new SmartList<JsExpression>();
    }

    public JsInvocation(JsExpression qualifier, List<JsExpression> arguments) {
        this.qualifier = qualifier;
        this.arguments = arguments;
    }

    public JsInvocation(JsExpression qualifier, JsExpression arg) {
        this(qualifier, Collections.singletonList(arg));
    }

    public JsInvocation(JsExpression qualifier, JsExpression ... arguments) {
        this(qualifier, Arrays.asList(arguments));
    }

    public JsInvocation(JsExpression qualifier) {
        this();
        this.qualifier = qualifier;
    }

    @Override
    public List<JsExpression> getArguments() {
        return this.arguments;
    }

    public JsExpression getQualifier() {
        return this.qualifier;
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.qualifier = v.accept(this.qualifier);
            v.acceptList(this.arguments);
        }
        v.endVisit(this, ctx);
    }
}

