/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MockFileIndexFacade
extends FileIndexFacade {
    private final Module myModule = null;
    private final List<VirtualFile> myLibraryRoots = new ArrayList<VirtualFile>();

    public MockFileIndexFacade(Project project) {
        super(project);
    }

    @Override
    public boolean isInContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileIndexFacade.isInContent must not be null");
        }
        return true;
    }

    @Override
    public boolean isInSource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileIndexFacade.isInSource must not be null");
        }
        return true;
    }

    @Override
    public boolean isInSourceContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileIndexFacade.isInSourceContent must not be null");
        }
        return true;
    }

    @Override
    public boolean isInLibraryClasses(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileIndexFacade.isInLibraryClasses must not be null");
        }
        for (VirtualFile libraryRoot : this.myLibraryRoots) {
            if (!VfsUtilCore.isAncestor(libraryRoot, file, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInLibrarySource(VirtualFile file) {
        return false;
    }

    @Override
    public boolean isExcludedFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileIndexFacade.isExcludedFile must not be null");
        }
        return false;
    }

    @Override
    public Module getModuleForFile(VirtualFile file) {
        return this.myModule;
    }

    public void addLibraryRoot(VirtualFile file) {
        this.myLibraryRoots.add(file);
    }
}

