/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.parser.DeclarationParser;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaParserFacadeImpl
implements PsiJavaParserFacade {
    protected final PsiManager myManager;
    private PsiJavaFile myDummyJavaFile;
    private static final String DUMMY_FILE_NAME = "_Dummy_." + JavaFileType.INSTANCE.getDefaultExtension();
    private static final JavaParserUtil.ParserWrapper ANNOTATION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseAnnotation(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper PARAMETER = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseParameter(builder, true, false);
        }
    };
    private static final JavaParserUtil.ParserWrapper RESOURCE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseResource(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper TYPE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseType(builder, 23);
        }
    };
    public static final JavaParserUtil.ParserWrapper REFERENCE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseJavaCodeReference(builder, false, true, false, false);
        }
    };
    public static final JavaParserUtil.ParserWrapper DIAMOND_REF = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseJavaCodeReference(builder, false, true, false, true);
        }
    };
    public static final JavaParserUtil.ParserWrapper STATIC_IMPORT_REF = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseImportCodeReference(builder, true);
        }
    };
    private static final JavaParserUtil.ParserWrapper TYPE_PARAMETER = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseTypeParameter(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper DECLARATION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parse(builder, DeclarationParser.Context.CLASS);
        }
    };
    private static final JavaParserUtil.ParserWrapper CODE_BLOCK = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getStatementParser().parseCodeBlockDeep(builder, true);
        }
    };
    private static final JavaParserUtil.ParserWrapper STATEMENT = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getStatementParser().parseStatement(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper EXPRESSION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getExpressionParser().parse(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper ENUM_CONSTANT = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseEnumConstant(builder);
        }
    };
    private static final Map<String, PsiPrimitiveType> PRIMITIVE_TYPES = new HashMap<String, PsiPrimitiveType>();

    public PsiJavaParserFacadeImpl(PsiManager manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public PsiAnnotation createAnnotationFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createAnnotationFromText must not be null");
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, ANNOTATION, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotation)) {
            throw new IncorrectOperationException("Incorrect annotation \"" + text + "\".");
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)element;
        if (psiAnnotation == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createAnnotationFromText must not return null");
        }
        return psiAnnotation;
    }

    @Override
    @NotNull
    public PsiDocTag createDocTagFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createDocTagFromText must not be null");
        }
        PsiDocTag psiDocTag = this.createDocCommentFromText(StringUtil.join("/**\n", text, "\n */")).getTags()[0];
        if (psiDocTag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createDocTagFromText must not return null");
        }
        return psiDocTag;
    }

    @Override
    @NotNull
    public PsiDocComment createDocCommentFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createDocCommentFromText must not be null");
        }
        PsiMethod method = this.createMethodFromText(StringUtil.join(text, "void m();"), null);
        PsiDocComment comment = method.getDocComment();
        assert (comment != null) : text;
        PsiDocComment psiDocComment = comment;
        if (psiDocComment == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createDocCommentFromText must not return null");
        }
        return psiDocComment;
    }

    @Override
    @NotNull
    public PsiClass createClassFromText(@NotNull String body, @Nullable PsiElement context) throws IncorrectOperationException {
        if (body == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createClassFromText must not be null");
        }
        PsiJavaFile aFile = this.createDummyJavaFile(StringUtil.join("class _Dummy_ {\n", body, "\n}"));
        PsiClass[] classes = aFile.getClasses();
        if (classes.length != 1) {
            throw new IncorrectOperationException("Incorrect class \"" + body + "\".");
        }
        PsiClass psiClass = classes[0];
        if (psiClass == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createClassFromText must not return null");
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiField createFieldFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createFieldFromText must not be null");
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, DECLARATION, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiField)) {
            throw new IncorrectOperationException("Incorrect field \"" + text + "\".");
        }
        PsiField psiField = (PsiField)element;
        if (psiField == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createFieldFromText must not return null");
        }
        return psiField;
    }

    @Override
    @NotNull
    public PsiMethod createMethodFromText(@NotNull String text, @Nullable PsiElement context, LanguageLevel level) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createMethodFromText must not be null");
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, DECLARATION, level), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiMethod)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect method \"" + text + "\".", holder);
        }
        PsiMethod psiMethod = (PsiMethod)element;
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createMethodFromText must not return null");
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public final PsiMethod createMethodFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createMethodFromText must not be null");
        }
        LanguageLevel level = LanguageLevelProjectExtension.getInstance(this.myManager.getProject()).getLanguageLevel();
        PsiMethod psiMethod = this.createMethodFromText(text, context, level);
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createMethodFromText must not return null");
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiParameter createParameterFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createParameterFromText must not be null");
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, PARAMETER, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiParameter)) {
            throw new IncorrectOperationException("Incorrect parameter \"" + text + "\".");
        }
        PsiParameter psiParameter = (PsiParameter)element;
        if (psiParameter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createParameterFromText must not return null");
        }
        return psiParameter;
    }

    @Override
    @NotNull
    public PsiResourceVariable createResourceFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createResourceFromText must not be null");
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, RESOURCE, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiResourceVariable)) {
            throw new IncorrectOperationException("Incorrect resource \"" + text + "\".");
        }
        PsiResourceVariable psiResourceVariable = (PsiResourceVariable)element;
        if (psiResourceVariable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createResourceFromText must not return null");
        }
        return psiResourceVariable;
    }

    @Override
    @NotNull
    public PsiType createTypeFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createTypeFromText must not be null");
        }
        PsiType psiType = this.createTypeInner(text, context, false);
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createTypeFromText must not return null");
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiTypeElement createTypeElementFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createTypeElementFromText must not be null");
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, TYPE, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiTypeElement)) {
            throw new IncorrectOperationException("Incorrect type \"" + text + "\".");
        }
        PsiTypeElement psiTypeElement = (PsiTypeElement)element;
        if (psiTypeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createTypeElementFromText must not return null");
        }
        return psiTypeElement;
    }

    protected PsiType createTypeInner(String text, @Nullable PsiElement context, boolean markAsCopy) throws IncorrectOperationException {
        PsiPrimitiveType primitiveType = PRIMITIVE_TYPES.get(text);
        if (primitiveType != null) {
            return primitiveType;
        }
        PsiTypeElement element = this.createTypeElementFromText(text, context);
        if (markAsCopy) {
            GeneratedMarkerVisitor.markGenerated(element);
        }
        return element.getType();
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createReferenceFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        boolean mayHaveDiamonds;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createReferenceFromText must not be null");
        }
        boolean isStaticImport = context instanceof PsiImportStaticStatement && !((PsiImportStaticStatement)context).isOnDemand();
        boolean bl = mayHaveDiamonds = context instanceof PsiNewExpression && PsiUtil.getLanguageLevel(context).isAtLeast(LanguageLevel.JDK_1_7);
        JavaParserUtil.ParserWrapper wrapper = isStaticImport ? STATIC_IMPORT_REF : (mayHaveDiamonds ? DIAMOND_REF : REFERENCE);
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, wrapper, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            throw new IncorrectOperationException("Incorrect reference \"" + text + "\".");
        }
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)element;
        if (psiJavaCodeReferenceElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createReferenceFromText must not return null");
        }
        return psiJavaCodeReferenceElement;
    }

    @Override
    @NotNull
    public PsiCodeBlock createCodeBlockFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createCodeBlockFromText must not be null");
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, CODE_BLOCK, PsiJavaParserFacadeImpl.level(context), true), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiCodeBlock)) {
            throw new IncorrectOperationException("Incorrect code block \"" + text + "\".");
        }
        PsiCodeBlock psiCodeBlock = (PsiCodeBlock)element;
        if (psiCodeBlock == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createCodeBlockFromText must not return null");
        }
        return psiCodeBlock;
    }

    @Override
    @NotNull
    public PsiStatement createStatementFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createStatementFromText must not be null");
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, STATEMENT, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiStatement)) {
            throw new IncorrectOperationException("Incorrect statement \"" + text + "\".");
        }
        PsiStatement psiStatement = (PsiStatement)element;
        if (psiStatement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createStatementFromText must not return null");
        }
        return psiStatement;
    }

    @Override
    @NotNull
    public PsiExpression createExpressionFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createExpressionFromText must not be null");
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, EXPRESSION, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiExpression)) {
            throw new IncorrectOperationException("Incorrect expression \"" + text + "\".");
        }
        PsiExpression psiExpression = (PsiExpression)element;
        if (psiExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createExpressionFromText must not return null");
        }
        return psiExpression;
    }

    protected PsiJavaFile createDummyJavaFile(String text) {
        JavaFileType type = JavaFileType.INSTANCE;
        return (PsiJavaFile)PsiFileFactory.getInstance(this.myManager.getProject()).createFileFromText(DUMMY_FILE_NAME, type, (CharSequence)text);
    }

    @Override
    @NotNull
    public PsiTypeParameter createTypeParameterFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createTypeParameterFromText must not be null");
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, TYPE_PARAMETER, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiTypeParameter)) {
            throw new IncorrectOperationException("Incorrect type parameter \"" + text + "\".");
        }
        PsiTypeParameter psiTypeParameter = (PsiTypeParameter)element;
        if (psiTypeParameter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createTypeParameterFromText must not return null");
        }
        return psiTypeParameter;
    }

    @Override
    @NotNull
    public PsiComment createCommentFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createCommentFromText must not be null");
        }
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        for (PsiElement aChildren : aFile.getChildren()) {
            if (!(aChildren instanceof PsiComment)) continue;
            if (!aChildren.getText().equals(text)) break;
            PsiComment comment = (PsiComment)aChildren;
            DummyHolderFactory.createHolder(this.myManager, (TreeElement)SourceTreeToPsiMap.psiElementToTree(comment), context);
            PsiComment psiComment = comment;
            if (psiComment == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createCommentFromText must not return null");
            }
            return psiComment;
        }
        throw new IncorrectOperationException("Incorrect comment \"" + text + "\".");
    }

    @Override
    @NotNull
    public PsiEnumConstant createEnumConstantFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createEnumConstantFromText must not be null");
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, ENUM_CONSTANT, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiEnumConstant)) {
            throw new IncorrectOperationException("Incorrect enum constant \"" + text + "\".");
        }
        PsiEnumConstant psiEnumConstant = (PsiEnumConstant)element;
        if (psiEnumConstant == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createEnumConstantFromText must not return null");
        }
        return psiEnumConstant;
    }

    @Override
    @NotNull
    public PsiType createPrimitiveType(@NotNull String text, @NotNull PsiAnnotation[] annotations) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createPrimitiveType must not be null");
        }
        if (annotations == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createPrimitiveType must not be null");
        }
        PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType(text);
        if (primitiveType == null) {
            throw new IncorrectOperationException("Incorrect primitive type \"" + text + "\".");
        }
        PsiPrimitiveType psiPrimitiveType = annotations.length == 0 ? primitiveType : new PsiPrimitiveType(text, annotations);
        if (psiPrimitiveType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createPrimitiveType must not return null");
        }
        return psiPrimitiveType;
    }

    public PsiJavaFile getDummyJavaFile() {
        if (this.myDummyJavaFile == null) {
            this.myDummyJavaFile = this.createDummyJavaFile("");
        }
        return this.myDummyJavaFile;
    }

    public static PsiPrimitiveType getPrimitiveType(String text) {
        return PRIMITIVE_TYPES.get(text);
    }

    protected static LanguageLevel level(@Nullable PsiElement context) {
        return context != null && context.isValid() ? PsiUtil.getLanguageLevel(context) : LanguageLevel.HIGHEST;
    }

    private static IncorrectOperationException newException(String msg, DummyHolder holder) {
        Throwable cause;
        FileElement root = holder.getTreeElement();
        if (root instanceof JavaDummyElement && (cause = ((JavaDummyElement)root).getParserError()) != null) {
            return new IncorrectOperationException(msg){

                @Override
                public Throwable getCause() {
                    return cause;
                }
            };
        }
        return new IncorrectOperationException(msg);
    }

    static {
        PRIMITIVE_TYPES.put(PsiType.BYTE.getCanonicalText(), PsiType.BYTE);
        PRIMITIVE_TYPES.put(PsiType.CHAR.getCanonicalText(), PsiType.CHAR);
        PRIMITIVE_TYPES.put(PsiType.DOUBLE.getCanonicalText(), PsiType.DOUBLE);
        PRIMITIVE_TYPES.put(PsiType.FLOAT.getCanonicalText(), PsiType.FLOAT);
        PRIMITIVE_TYPES.put(PsiType.INT.getCanonicalText(), PsiType.INT);
        PRIMITIVE_TYPES.put(PsiType.LONG.getCanonicalText(), PsiType.LONG);
        PRIMITIVE_TYPES.put(PsiType.SHORT.getCanonicalText(), PsiType.SHORT);
        PRIMITIVE_TYPES.put(PsiType.BOOLEAN.getCanonicalText(), PsiType.BOOLEAN);
        PRIMITIVE_TYPES.put(PsiType.VOID.getCanonicalText(), PsiType.VOID);
        PRIMITIVE_TYPES.put(PsiType.NULL.getCanonicalText(), PsiType.NULL);
    }
}

