/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.source.PsiParameterImpl;
import com.intellij.psi.impl.source.PsiReceiverParameterImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class JavaParameterElementType
extends JavaStubElementType<PsiParameterStub, PsiParameter> {
    public static final TokenSet ID_TYPES = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.THIS_KEYWORD);

    public JavaParameterElementType(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaParameterElementType.<init> must not be null");
        }
        super(id);
    }

    @Override
    public PsiParameter createPsi(@NotNull PsiParameterStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaParameterElementType.createPsi must not be null");
        }
        return this.getPsiFactory(stub).createParameter(stub);
    }

    @Override
    public PsiParameter createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaParameterElementType.createPsi must not be null");
        }
        boolean receiver = node.getElementType() == JavaElementType.RECEIVER_PARAMETER;
        return receiver ? new PsiReceiverParameterImpl(node) : new PsiParameterImpl(node);
    }

    @Override
    public PsiParameterStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        TypeInfo typeInfo = TypeInfo.create(tree, node, parentStub);
        LighterASTNode id = LightTreeUtil.requiredChildOfType(tree, node, ID_TYPES);
        String name = RecordUtil.intern(tree.getCharTable(), id);
        return new PsiParameterStubImpl(parentStub, name, typeInfo, typeInfo.isEllipsis);
    }

    @Override
    public void serialize(PsiParameterStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getType(false));
        dataStream.writeBoolean(stub.isParameterTypeEllipsis());
    }

    @Override
    public PsiParameterStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        TypeInfo type = TypeInfo.readTYPE(dataStream);
        boolean isEllipsis = dataStream.readBoolean();
        return new PsiParameterStubImpl(parentStub, name, type, isEllipsis);
    }

    @Override
    public void indexStub(PsiParameterStub stub, IndexSink sink) {
    }
}

