/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class FileElement
extends LazyParseableElement
implements FileASTNode {
    private volatile CharTable myCharTable = new CharTableImpl();

    @Override
    @NotNull
    public CharTable getCharTable() {
        CharTable charTable = this.myCharTable;
        if (charTable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/FileElement.getCharTable must not return null");
        }
        return charTable;
    }

    public FileElement(IElementType type, CharSequence text) {
        super(type, text);
    }

    @Deprecated
    public FileElement(IElementType type) {
        super(type, null);
    }

    @Override
    public PsiManagerEx getManager() {
        CompositeElement treeParent = this.getTreeParent();
        if (treeParent != null) {
            return treeParent.getManager();
        }
        return (PsiManagerEx)this.getPsi().getManager();
    }

    @Override
    public ASTNode copyElement() {
        PsiFileImpl psiElement = (PsiFileImpl)this.getPsi();
        PsiFileImpl psiElementCopy = (PsiFileImpl)psiElement.copy();
        return psiElementCopy.getTreeElement();
    }

    public void setCharTable(CharTable table) {
        this.myCharTable = table;
    }
}

