/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.text;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BlockSupport {
    public static final Key<Boolean> DO_NOT_REPARSE_INCREMENTALLY = Key.create("DO_NOT_REPARSE_INCREMENTALLY");
    public static final Key<ASTNode> TREE_TO_BE_REPARSED = Key.create("TREE_TO_BE_REPARSED");
    public static final int INCREMENTAL_REPARSE_DEPTH_LIMIT = Registry.intValue("psi.incremental.reparse.depth.limit", 1000);
    public static final Key<Boolean> TREE_DEPTH_LIMIT_EXCEEDED = Key.create("TREE_IS_TOO_DEEP");

    public static BlockSupport getInstance(Project project) {
        return ServiceManager.getService(project, BlockSupport.class);
    }

    public abstract void reparseRange(PsiFile var1, int var2, int var3, @NonNls CharSequence var4) throws IncorrectOperationException;

    @NotNull
    public abstract DiffLog reparseRange(@NotNull PsiFile var1, int var2, int var3, int var4, @NotNull CharSequence var5, @NotNull ProgressIndicator var6) throws IncorrectOperationException;

    public static boolean isTooDeep(UserDataHolder element) {
        return element != null && Boolean.TRUE.equals(element.getUserData(TREE_DEPTH_LIMIT_EXCEEDED));
    }

    public static class ReparsedSuccessfullyException
    extends RuntimeException {
        private final DiffLog myDiffLog;

        public ReparsedSuccessfullyException(@NotNull DiffLog diffLog) {
            if (diffLog == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/text/BlockSupport$ReparsedSuccessfullyException.<init> must not be null");
            }
            this.myDiffLog = diffLog;
        }

        @NotNull
        public DiffLog getDiffLog() {
            DiffLog diffLog = this.myDiffLog;
            if (diffLog == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/text/BlockSupport$ReparsedSuccessfullyException.getDiffLog must not return null");
            }
            return diffLog;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

