/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.CharArrayCharSequence;
import gnu.trove.Equality;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayUtil
extends ArrayUtilRt {
    public static final short[] EMPTY_SHORT_ARRAY = ArrayUtilRt.EMPTY_SHORT_ARRAY;
    public static final char[] EMPTY_CHAR_ARRAY = ArrayUtilRt.EMPTY_CHAR_ARRAY;
    public static final byte[] EMPTY_BYTE_ARRAY = ArrayUtilRt.EMPTY_BYTE_ARRAY;
    public static final int[] EMPTY_INT_ARRAY = ArrayUtilRt.EMPTY_INT_ARRAY;
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = ArrayUtilRt.EMPTY_BOOLEAN_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY = ArrayUtilRt.EMPTY_STRING_ARRAY;
    public static final Class[] EMPTY_CLASS_ARRAY = ArrayUtilRt.EMPTY_CLASS_ARRAY;
    public static final long[] EMPTY_LONG_ARRAY = ArrayUtilRt.EMPTY_LONG_ARRAY;
    public static final Collection[] EMPTY_COLLECTION_ARRAY = ArrayUtilRt.EMPTY_COLLECTION_ARRAY;
    public static final File[] EMPTY_FILE_ARRAY = ArrayUtilRt.EMPTY_FILE_ARRAY;
    public static final Runnable[] EMPTY_RUNNABLE_ARRAY = ArrayUtilRt.EMPTY_RUNNABLE_ARRAY;
    public static final CharSequence EMPTY_CHAR_SEQUENCE = new CharArrayCharSequence(EMPTY_CHAR_ARRAY);
    public static final ArrayFactory<String> STRING_ARRAY_FACTORY = new ArrayFactory<String>(){

        public String[] create(int count) {
            return ArrayUtil.newStringArray(count);
        }
    };
    public static final ArrayFactory<Object> OBJECT_ARRAY_FACTORY = new ArrayFactory<Object>(){

        @Override
        public Object[] create(int count) {
            return ArrayUtil.newObjectArray(count);
        }
    };

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static char[] realloc(@NotNull char[] array, int newSize) {
        char[] cArray;
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.realloc must not be null");
        }
        if (newSize == 0) {
            cArray = EMPTY_CHAR_ARRAY;
            if (EMPTY_CHAR_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.realloc must not return null");
            return cArray;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            cArray = array;
            if (array == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.realloc must not return null");
            return cArray;
        }
        char[] result = new char[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        cArray = result;
        if (result != null) return cArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.realloc must not return null");
    }

    @NotNull
    public static <T> T[] toObjectArray(@NotNull Collection<T> collection, @NotNull Class<T> aClass) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.toObjectArray must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.toObjectArray must not be null");
        }
        Object[] array = (Object[])Array.newInstance(aClass, collection.size());
        Object[] objectArray = collection.toArray(array);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.toObjectArray must not return null");
        }
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Object[] toObjectArray(@NotNull Collection<?> collection) {
        Object[] objectArray;
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.toObjectArray must not be null");
        }
        if (collection.isEmpty()) {
            objectArray = EMPTY_OBJECT_ARRAY;
            if (EMPTY_OBJECT_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.toObjectArray must not return null");
            return objectArray;
        }
        objectArray = collection.toArray(new Object[collection.size()]);
        if (objectArray != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.toObjectArray must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> T[] mergeArrays(@NotNull T[] a1, @NotNull T[] a2) {
        Class<?> class2;
        Object[] objectArray;
        if (a1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrays must not be null");
        }
        if (a1.length == 0) {
            objectArray = a2;
            if (a2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
            return objectArray;
        }
        if (a2.length == 0) {
            objectArray = a1;
            if (a1 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
            return objectArray;
        }
        Class<?> class1 = a1.getClass().getComponentType();
        Class<?> aClass = class1.isAssignableFrom(class2 = a2.getClass().getComponentType()) ? class1 : class2;
        Object[] result = (Object[])Array.newInstance(aClass, a1.length + a2.length);
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        objectArray = result;
        if (result != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrays must not return null");
    }

    @NotNull
    public static <T> T[] mergeCollections(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<T> factory) {
        if (c1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeCollections must not be null");
        }
        if (c2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeCollections must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeCollections must not be null");
        }
        T[] res = factory.create(c1.size() + c2.size());
        int i = 0;
        for (T t : c1) {
            res[i++] = t;
        }
        for (T t : c2) {
            res[i++] = t;
        }
        if (res == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeCollections must not return null");
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static <T> T[] mergeArrayAndCollection(@NotNull T[] array, @NotNull Collection<T> collection, @NotNull ArrayFactory<T> factory) {
        T[] array2;
        T[] TArray;
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrayAndCollection must not be null");
        }
        if (collection == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrayAndCollection must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ArrayUtil.mergeArrayAndCollection must not be null");
        }
        if (collection.isEmpty()) {
            TArray = array;
            if (array == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrayAndCollection must not return null");
            return TArray;
        }
        try {
            array2 = collection.toArray(factory.create(collection.size()));
        }
        catch (ArrayStoreException e) {
            throw new RuntimeException("Bad elements in collection: " + collection, e);
        }
        if (array.length == 0) {
            TArray = array2;
            if (array2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrayAndCollection must not return null");
            return TArray;
        }
        T[] result = factory.create(array.length + collection.size());
        System.arraycopy(array, 0, result, 0, array.length);
        System.arraycopy(array2, 0, result, array.length, array2.length);
        TArray = result;
        if (result != null) return TArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.mergeArrayAndCollection must not return null");
    }

    @NotNull
    public static <T> T[] append(@NotNull T[] src, @Nullable T element) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.append must not be null");
        }
        T[] TArray = ArrayUtil.append(src, element, src.getClass().getComponentType());
        if (TArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.append must not return null");
        }
        return TArray;
    }

    public static <T> T[] append(@NotNull T[] src, T element, @NotNull ArrayFactory<T> factory) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.append must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ArrayUtil.append must not be null");
        }
        int length = src.length;
        T[] result = factory.create(length + 1);
        System.arraycopy(src, 0, result, 0, length);
        result[length] = element;
        return result;
    }

    @NotNull
    public static <T> T[] append(@NotNull T[] src, @Nullable T element, @NotNull Class<T> componentType) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.append must not be null");
        }
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ArrayUtil.append must not be null");
        }
        int length = src.length;
        Object[] result = (Object[])Array.newInstance(componentType, length + 1);
        System.arraycopy(src, 0, result, 0, length);
        result[length] = element;
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.append must not return null");
        }
        return result;
    }

    @NotNull
    public static <T> T[] remove(@NotNull T[] src, int idx) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.remove must not be null");
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        Object[] result = (Object[])Array.newInstance(src.getClass().getComponentType(), length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.remove must not return null");
        }
        return result;
    }

    @NotNull
    public static int[] remove(@NotNull int[] src, int idx) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.remove must not be null");
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        int[] result = ArrayUtil.newIntArray(src.length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.remove must not return null");
        }
        return result;
    }

    public static boolean startsWith(byte[] array, byte[] prefix) {
        if (array == prefix) {
            return true;
        }
        if (array == null || prefix == null) {
            return false;
        }
        int length = prefix.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static <T> void swap(@NotNull T[] array, int i1, int i2) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.swap must not be null");
        }
        T t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static int indexOf(@NotNull Object[] objects, @Nullable Object object) {
        if (objects == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.indexOf must not be null");
        }
        for (int i = 0; i < objects.length; ++i) {
            if (!Comparing.equal(objects[i], object)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(@NotNull List<T> objects, T object, @NotNull Equality<T> comparator) {
        if (objects == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.indexOf must not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ArrayUtil.indexOf must not be null");
        }
        for (int i = 0; i < objects.size(); ++i) {
            if (!comparator.equals(objects.get(i), object)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(@NotNull int[] ints, int value) {
        if (ints == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.indexOf must not be null");
        }
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public static int[] newIntArray(int count) {
        int[] nArray = count == 0 ? EMPTY_INT_ARRAY : new int[count];
        if (nArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.newIntArray must not return null");
        }
        return nArray;
    }

    @NotNull
    public static String[] newStringArray(int count) {
        String[] stringArray = count == 0 ? EMPTY_STRING_ARRAY : new String[count];
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.newStringArray must not return null");
        }
        return stringArray;
    }

    @NotNull
    public static Object[] newObjectArray(int count) {
        Object[] objectArray = count == 0 ? EMPTY_OBJECT_ARRAY : new Object[count];
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.newObjectArray must not return null");
        }
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <E> E[] ensureExactSize(int count, @NotNull E[] sample) {
        Object[] objectArray;
        if (sample == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ArrayUtil.ensureExactSize must not be null");
        }
        if (count == sample.length) {
            objectArray = sample;
            if (sample == null) throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.ensureExactSize must not return null");
            return objectArray;
        }
        Object[] array = (Object[])Array.newInstance(sample.getClass().getComponentType(), count);
        objectArray = array;
        if (array != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.ensureExactSize must not return null");
    }

    @Nullable
    public static <T> T getLastElement(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ArrayUtil.getLastElement must not be null");
        }
        return array.length > 0 ? (T)array[array.length - 1] : null;
    }

    @NotNull
    public static String[] toStringArray(@Nullable Collection<String> collection) {
        String[] stringArray = ArrayUtilRt.toStringArray(collection);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ArrayUtil.toStringArray must not return null");
        }
        return stringArray;
    }
}

