/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import com.intellij.util.keyFMap.ArrayBackedFMap;
import com.intellij.util.keyFMap.KeyFMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import org.jetbrains.annotations.NotNull;

class MapBackedFMap
extends TIntObjectHashMap<Object>
implements KeyFMap {
    private MapBackedFMap(@NotNull MapBackedFMap oldMap, final int exclude) {
        if (oldMap == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/keyFMap/MapBackedFMap.<init> must not be null");
        }
        super(oldMap.size());
        oldMap.forEachEntry(new TIntObjectProcedure<Object>(){

            @Override
            public boolean execute(int key, Object val) {
                if (key != exclude) {
                    MapBackedFMap.this.put(key, val);
                }
                assert (key >= 0) : key;
                return true;
            }
        });
        assert (this.size() > 8);
    }

    MapBackedFMap(@NotNull int[] keys, int newKey, @NotNull Object[] values, @NotNull Object newValue) {
        if (keys == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/keyFMap/MapBackedFMap.<init> must not be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/keyFMap/MapBackedFMap.<init> must not be null");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/util/keyFMap/MapBackedFMap.<init> must not be null");
        }
        super(keys.length + 1);
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            Object value = values[i];
            this.put(key, value);
            assert (key >= 0) : key;
        }
        this.put(newKey, newValue);
        assert (newKey >= 0) : newKey;
        assert (this.size() > 8);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        MapBackedFMap mapBackedFMap;
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/keyFMap/MapBackedFMap.plus must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/keyFMap/MapBackedFMap.plus must not be null");
        }
        int keyCode = key.hashCode();
        assert (keyCode >= 0) : key;
        Object oldValue = this.get(keyCode);
        if (value == oldValue) {
            mapBackedFMap = this;
            if (mapBackedFMap == null) throw new IllegalStateException("@NotNull method com/intellij/util/keyFMap/MapBackedFMap.plus must not return null");
            return mapBackedFMap;
        }
        MapBackedFMap newMap = new MapBackedFMap(this, -1);
        newMap.put(keyCode, value);
        mapBackedFMap = newMap;
        if (mapBackedFMap != null) return mapBackedFMap;
        throw new IllegalStateException("@NotNull method com/intellij/util/keyFMap/MapBackedFMap.plus must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        KeyFMap keyFMap;
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/keyFMap/MapBackedFMap.minus must not be null");
        }
        int oldSize = this.size();
        int keyCode = key.hashCode();
        if (!this.containsKey(keyCode)) {
            keyFMap = this;
            if (keyFMap == null) throw new IllegalStateException("@NotNull method com/intellij/util/keyFMap/MapBackedFMap.minus must not return null");
            return keyFMap;
        }
        if (oldSize == 9) {
            int[] keys = this.keys();
            Object[] values = this.getValues();
            int i = ArrayUtil.indexOf(keys, keyCode);
            keyFMap = new ArrayBackedFMap(keys = ArrayUtil.remove(keys, i), values = ArrayUtil.remove(values, i));
            if (keyFMap == null) throw new IllegalStateException("@NotNull method com/intellij/util/keyFMap/MapBackedFMap.minus must not return null");
            return keyFMap;
        }
        keyFMap = new MapBackedFMap(this, keyCode);
        if (keyFMap != null) return keyFMap;
        throw new IllegalStateException("@NotNull method com/intellij/util/keyFMap/MapBackedFMap.minus must not return null");
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/keyFMap/MapBackedFMap.get must not be null");
        }
        return this.get(key.hashCode());
    }

    @Override
    public String toString() {
        final StringBuilder s = new StringBuilder();
        this.forEachEntry(new TIntObjectProcedure<Object>(){

            @Override
            public boolean execute(int key, Object value) {
                s.append(s.length() == 0 ? "" : ", ").append(Key.getKeyByIndex(key)).append(" -> ").append(value);
                return true;
            }
        });
        return "[" + s.toString() + "]";
    }
}

