/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.THash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import java.io.Serializable;

public abstract class TObjectHash<T>
extends THash
implements TObjectHashingStrategy<T>,
Serializable {
    protected transient Object[] _set;
    protected TObjectHashingStrategy<T> _hashingStrategy;
    public static final Object REMOVED = new Object();

    public TObjectHash() {
        this._hashingStrategy = this;
    }

    public TObjectHash(TObjectHashingStrategy<T> strategy) {
        this._hashingStrategy = strategy;
    }

    public TObjectHash(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TObjectHash(int initialCapacity, TObjectHashingStrategy<T> strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TObjectHash(int initialCapacity, float loadFactor, TObjectHashingStrategy<T> strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    @Override
    public TObjectHash<T> clone() {
        TObjectHash h = (TObjectHash)super.clone();
        h._set = (Object[])this._set.clone();
        return h;
    }

    @Override
    protected int capacity() {
        return this._set.length;
    }

    @Override
    protected void removeAt(int index) {
        this._set[index] = REMOVED;
        super.removeAt(index);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new Object[capacity];
        return capacity;
    }

    public boolean forEach(TObjectProcedure<T> procedure) {
        Object[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (set[i] == null || set[i] == REMOVED || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object obj) {
        return this.index(obj) >= 0;
    }

    protected int index(T obj) {
        Object[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(obj) & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (!(cur == null || cur != REMOVED && this._hashingStrategy.equals(cur, obj))) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && (cur == REMOVED || !this._hashingStrategy.equals(cur, obj)));
        }
        return cur == null ? -1 : index;
    }

    protected int insertionIndex(T obj) {
        Object[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(obj) & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (cur == null) {
            return index;
        }
        if (cur != REMOVED && this._hashingStrategy.equals(cur, obj)) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index -= probe) >= 0) continue;
            index += length;
        } while ((cur = set[index]) != null && cur != REMOVED && !this._hashingStrategy.equals(cur, obj));
        if (cur == REMOVED) {
            int firstRemoved = index;
            while (!(cur == null || cur != REMOVED && this._hashingStrategy.equals(cur, obj))) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != null && cur != REMOVED ? -index - 1 : firstRemoved;
        }
        return cur != null ? -index - 1 : index;
    }

    @Override
    public final int computeHashCode(T o) {
        return o != null ? o.hashCode() : 0;
    }

    @Override
    public final boolean equals(T o1, T o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    protected final void throwObjectContractViolation(Object o1, Object o2) throws IllegalArgumentException {
        throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + o1 + "; object #2 =" + o2);
    }
}

