/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.cfg.JetControlFlowProcessor;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.ReadValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.VariableDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.WriteValueInstruction;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class PseudocodeUtil {
    public static Pseudocode generatePseudocode(@NotNull JetDeclaration declaration, final @NotNull BindingContext bindingContext) {
        BindingTrace mockTrace = new BindingTrace(){

            @Override
            public BindingContext getBindingContext() {
                return bindingContext;
            }

            @Override
            public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
            }

            @Override
            public <K> void record(WritableSlice<K, Boolean> slice, K key) {
            }

            @Override
            public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
                return bindingContext.get(slice, key);
            }

            @Override
            @NotNull
            public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
                return bindingContext.getKeys(slice);
            }

            @Override
            public void report(@NotNull Diagnostic diagnostic) {
            }
        };
        return new JetControlFlowProcessor(mockTrace).generatePseudocode(declaration);
    }

    @Nullable
    public static VariableDescriptor extractVariableDescriptorIfAny(@NotNull Instruction instruction, boolean onlyReference, @NotNull BindingContext bindingContext) {
        JetElement element = null;
        if (instruction instanceof ReadValueInstruction) {
            element = ((ReadValueInstruction)instruction).getElement();
        } else if (instruction instanceof WriteValueInstruction) {
            element = ((WriteValueInstruction)instruction).getlValue();
        } else if (instruction instanceof VariableDeclarationInstruction) {
            element = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement();
        }
        return BindingContextUtils.extractVariableDescriptorIfAny(bindingContext, element, onlyReference);
    }
}

