/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.ModuleConfiguration;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class ModuleDescriptorImpl
extends DeclarationDescriptorImpl
implements ClassOrNamespaceDescriptor,
ModuleDescriptor {
    private NamespaceDescriptor rootNamepsace;
    private ModuleConfiguration moduleConfiguration;
    private final List<ImportPath> defaultImports;
    private final PlatformToKotlinClassMap platformToKotlinClassMap;

    public ModuleDescriptorImpl(@NotNull Name name, @NotNull List<ImportPath> defaultImports, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
        super(Collections.<AnnotationDescriptor>emptyList(), name);
        if (!name.isSpecial()) {
            throw new IllegalArgumentException("module name must be special: " + name);
        }
        this.defaultImports = defaultImports;
        this.platformToKotlinClassMap = platformToKotlinClassMap;
    }

    public void setRootNamespace(@NotNull NamespaceDescriptor rootNs) {
        if (this.rootNamepsace != null) {
            throw new IllegalStateException("setRootNamespace() is called twice");
        }
        this.rootNamepsace = rootNs;
    }

    @Override
    @Nullable
    public DeclarationDescriptor getContainingDeclaration() {
        return null;
    }

    @Override
    @Nullable
    public NamespaceDescriptor getNamespace(@NotNull FqName fqName) {
        if (fqName.isRoot()) {
            return this.rootNamepsace;
        }
        NamespaceDescriptor current = this.rootNamepsace;
        for (Name simpleName : fqName.pathSegments()) {
            if ((current = current.getMemberScope().getNamespace(simpleName)) != null) continue;
            return null;
        }
        return current;
    }

    @Override
    @NotNull
    public ModuleConfiguration getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    public ModuleDescriptorImpl setModuleConfiguration(@NotNull ModuleConfiguration moduleConfiguration) {
        assert (this.moduleConfiguration == null) : "Trying to set module configuration twice for " + this;
        this.moduleConfiguration = moduleConfiguration;
        return this;
    }

    @Override
    @NotNull
    public List<ImportPath> getDefaultImports() {
        return this.defaultImports;
    }

    @Override
    @NotNull
    public PlatformToKotlinClassMap getPlatformToKotlinClassMap() {
        return this.platformToKotlinClassMap;
    }

    public NamespaceDescriptorImpl getRootNamespaceDescriptorImpl() {
        return (NamespaceDescriptorImpl)this.rootNamepsace;
    }

    @Override
    @NotNull
    public ModuleDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        return this;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitModuleDeclaration(this, data);
    }

    @Override
    public void addNamespace(@NotNull NamespaceDescriptor namespaceDescriptor) {
        if (namespaceDescriptor.getContainingDeclaration() != this) {
            throw new IllegalStateException();
        }
        this.setRootNamespace(namespaceDescriptor);
    }
}

