/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategy;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetNullableType;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetWhenConditionInRange;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;

public class PositioningStrategies {
    public static final PositioningStrategy<PsiElement> DEFAULT = new PositioningStrategy();
    public static final PositioningStrategy<JetDeclaration> DECLARATION_RETURN_TYPE = new PositioningStrategy<JetDeclaration>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetDeclaration declaration) {
            return 1.markElement(this.getElementToMark(declaration));
        }

        @Override
        public boolean isValid(@NotNull JetDeclaration declaration) {
            return !1.hasSyntaxErrors(this.getElementToMark(declaration));
        }

        private PsiElement getElementToMark(@NotNull JetDeclaration declaration) {
            JetTypeReference returnTypeRef = null;
            PsiElement nameIdentifierOrPlaceholder = null;
            if (declaration instanceof JetNamedFunction) {
                JetNamedFunction function = (JetNamedFunction)declaration;
                returnTypeRef = function.getReturnTypeRef();
                nameIdentifierOrPlaceholder = function.getNameIdentifier();
            } else if (declaration instanceof JetProperty) {
                JetProperty property = (JetProperty)declaration;
                returnTypeRef = property.getTypeRef();
                nameIdentifierOrPlaceholder = property.getNameIdentifier();
            } else if (declaration instanceof JetPropertyAccessor) {
                JetPropertyAccessor accessor = (JetPropertyAccessor)declaration;
                returnTypeRef = accessor.getReturnTypeReference();
                nameIdentifierOrPlaceholder = accessor.getNamePlaceholder();
            }
            if (returnTypeRef != null) {
                return returnTypeRef;
            }
            if (nameIdentifierOrPlaceholder != null) {
                return nameIdentifierOrPlaceholder;
            }
            return declaration;
        }
    };
    public static final PositioningStrategy<PsiNameIdentifierOwner> NAME_IDENTIFIER = new PositioningStrategy<PsiNameIdentifierOwner>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiNameIdentifierOwner element) {
            PsiElement nameIdentifier = element.getNameIdentifier();
            if (nameIdentifier != null) {
                return 2.markElement(nameIdentifier);
            }
            return 2.markElement(element);
        }
    };
    public static final PositioningStrategy<PsiNameIdentifierOwner> NAMED_ELEMENT = new PositioningStrategy<PsiNameIdentifierOwner>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiNameIdentifierOwner element) {
            if (element instanceof JetNamedFunction) {
                JetNamedFunction function = (JetNamedFunction)element;
                JetParameterList valueParameterList = function.getValueParameterList();
                JetTypeReference returnTypeRef = function.getReturnTypeRef();
                PsiElement nameIdentifier = function.getNameIdentifier();
                PsiElement endOfSignatureElement = returnTypeRef != null ? returnTypeRef : (valueParameterList != null ? valueParameterList : (nameIdentifier != null ? nameIdentifier : function));
                return 3.markRange(new TextRange(function.getTextRange().getStartOffset(), endOfSignatureElement.getTextRange().getEndOffset()));
            }
            if (element instanceof JetProperty) {
                JetProperty property = (JetProperty)element;
                JetTypeReference propertyTypeRef = property.getTypeRef();
                PsiElement nameIdentifier = property.getNameIdentifier();
                PsiElement endOfSignatureElement = propertyTypeRef != null ? propertyTypeRef : (nameIdentifier != null ? nameIdentifier : property);
                return 3.markRange(new TextRange(property.getTextRange().getStartOffset(), endOfSignatureElement.getTextRange().getEndOffset()));
            }
            if (element instanceof JetClass) {
                JetClass klass = (JetClass)element;
                PsiElement nameAsDeclaration = klass.getNameIdentifier();
                if (nameAsDeclaration == null) {
                    return 3.markElement(klass);
                }
                JetParameterList primaryConstructorParameterList = klass.getPrimaryConstructorParameterList();
                if (primaryConstructorParameterList == null) {
                    return 3.markRange(nameAsDeclaration.getTextRange());
                }
                return 3.markRange(new TextRange(nameAsDeclaration.getTextRange().getStartOffset(), primaryConstructorParameterList.getTextRange().getEndOffset()));
            }
            return super.mark(element);
        }

        @Override
        public boolean isValid(@NotNull PsiNameIdentifierOwner element) {
            return element.getNameIdentifier() != null && super.isValid(element);
        }
    };
    public static final PositioningStrategy<JetDeclaration> DECLARATION = new PositioningStrategy<JetDeclaration>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetDeclaration element) {
            if (element instanceof PsiNameIdentifierOwner) {
                return NAMED_ELEMENT.mark((PsiNameIdentifierOwner)((Object)element));
            }
            return super.mark(element);
        }

        @Override
        public boolean isValid(@NotNull JetDeclaration element) {
            if (element instanceof PsiNameIdentifierOwner) {
                return NAMED_ELEMENT.isValid((PsiNameIdentifierOwner)((Object)element));
            }
            return super.isValid(element);
        }
    };
    public static final PositioningStrategy<JetModifierListOwner> ABSTRACT_MODIFIER = PositioningStrategies.modifierSetPosition(JetTokens.ABSTRACT_KEYWORD);
    public static final PositioningStrategy<JetModifierListOwner> OVERRIDE_MODIFIER = PositioningStrategies.modifierSetPosition(JetTokens.OVERRIDE_KEYWORD);
    public static final PositioningStrategy<JetModifierListOwner> FINAL_MODIFIER = PositioningStrategies.modifierSetPosition(JetTokens.FINAL_KEYWORD);
    public static final PositioningStrategy<JetModifierListOwner> VARIANCE_MODIFIER = PositioningStrategies.modifierSetPosition(JetTokens.IN_KEYWORD, JetTokens.OUT_KEYWORD);
    public static final PositioningStrategy<PsiElement> FOR_REDECLARATION = new PositioningStrategy<PsiElement>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            JetFile file;
            PsiElement nameIdentifier;
            if (element instanceof JetNamedDeclaration) {
                PsiElement nameIdentifier2 = ((JetNamedDeclaration)element).getNameIdentifier();
                if (nameIdentifier2 != null) {
                    return 5.markElement(nameIdentifier2);
                }
            } else if (element instanceof JetFile && (nameIdentifier = (file = (JetFile)element).getNamespaceHeader().getNameIdentifier()) != null) {
                return 5.markElement(nameIdentifier);
            }
            return 5.markElement(element);
        }
    };
    public static final PositioningStrategy<JetReferenceExpression> FOR_UNRESOLVED_REFERENCE = new PositioningStrategy<JetReferenceExpression>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetReferenceExpression element) {
            List<TextRange> ranges;
            if (element instanceof JetArrayAccessExpression && !(ranges = ((JetArrayAccessExpression)element).getBracketRanges()).isEmpty()) {
                return ranges;
            }
            return Collections.singletonList(element.getTextRange());
        }
    };
    public static final PositioningStrategy<JetArrayAccessExpression> ARRAY_ACCESS = new PositioningStrategy<JetArrayAccessExpression>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetArrayAccessExpression element) {
            return 8.markElement(element.getIndicesNode());
        }
    };
    public static final PositioningStrategy<JetModifierListOwner> VISIBILITY_MODIFIER = new PositioningStrategy<JetModifierListOwner>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetModifierListOwner element) {
            JetObjectDeclaration objectDeclaration;
            PsiElement nameIdentifier;
            ArrayList<JetKeywordToken> visibilityTokens = Lists.newArrayList(JetTokens.PRIVATE_KEYWORD, JetTokens.PROTECTED_KEYWORD, JetTokens.PUBLIC_KEYWORD, JetTokens.INTERNAL_KEYWORD);
            ArrayList<TextRange> result = Lists.newArrayList();
            for (JetKeywordToken token : visibilityTokens) {
                if (!element.hasModifier(token)) continue;
                result.add(element.getModifierList().getModifierNode(token).getTextRange());
            }
            if (!result.isEmpty()) {
                return result;
            }
            if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)((Object)element)).getNameIdentifier()) != null) {
                return ImmutableList.of(nameIdentifier.getTextRange());
            }
            if (element instanceof JetPropertyAccessor) {
                return ImmutableList.of(((JetPropertyAccessor)element).getNamePlaceholder().getTextRange());
            }
            if (element instanceof JetClassInitializer) {
                return ImmutableList.of(element.getTextRange());
            }
            if (element instanceof JetClassObject && (objectDeclaration = ((JetClassObject)element).getObjectDeclaration()) != null) {
                return ImmutableList.of(objectDeclaration.getObjectKeyword().getTextRange());
            }
            throw new IllegalArgumentException(String.format("Can't find text range for element '%s' with the text '%s'", element.getClass().getCanonicalName(), element.getText()));
        }
    };
    public static final PositioningStrategy<JetTypeProjection> VARIANCE_IN_PROJECTION = new PositioningStrategy<JetTypeProjection>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetTypeProjection element) {
            return 10.markNode(element.getProjectionNode());
        }
    };
    public static final PositioningStrategy<JetParameter> PARAMETER_DEFAULT_VALUE = new PositioningStrategy<JetParameter>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetParameter element) {
            return 11.markNode(element.getDefaultValue().getNode());
        }
    };
    public static final PositioningStrategy<PsiElement> CALL_ELEMENT = new PositioningStrategy<PsiElement>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiElement callElement) {
            JetExpression calleeExpression;
            if (callElement instanceof JetCallElement && (calleeExpression = ((JetCallElement)callElement).getCalleeExpression()) != null) {
                return 12.markElement(calleeExpression);
            }
            return 12.markElement(callElement);
        }
    };
    public static final PositioningStrategy<JetDeclarationWithBody> DECLARATION_WITH_BODY = new PositioningStrategy<JetDeclarationWithBody>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetDeclarationWithBody element) {
            TextRange lastBracketRange;
            JetExpression bodyExpression = element.getBodyExpression();
            if (bodyExpression instanceof JetBlockExpression && (lastBracketRange = ((JetBlockExpression)bodyExpression).getLastBracketRange()) != null) {
                return 13.markRange(lastBracketRange);
            }
            return 13.markElement(element);
        }

        @Override
        public boolean isValid(@NotNull JetDeclarationWithBody element) {
            if (!super.isValid(element)) {
                return false;
            }
            JetExpression bodyExpression = element.getBodyExpression();
            if (!(bodyExpression instanceof JetBlockExpression)) {
                return false;
            }
            return ((JetBlockExpression)bodyExpression).getLastBracketRange() != null;
        }
    };
    public static final PositioningStrategy<JetProperty> VAL_OR_VAR_NODE = new PositioningStrategy<JetProperty>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetProperty property) {
            return 14.markNode(property.getValOrVarNode());
        }
    };
    public static final PositioningStrategy<JetWhenEntry> ELSE_ENTRY = new PositioningStrategy<JetWhenEntry>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetWhenEntry entry) {
            PsiElement elseKeywordElement = entry.getElseKeywordElement();
            assert (elseKeywordElement != null);
            return 15.markElement(elseKeywordElement);
        }
    };
    public static final PositioningStrategy<JetWhenExpression> WHEN_EXPRESSION = new PositioningStrategy<JetWhenExpression>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetWhenExpression element) {
            return 16.markElement(element.getWhenKeywordElement());
        }
    };
    public static final PositioningStrategy<JetWhenConditionInRange> WHEN_CONDITION_IN_RANGE = new PositioningStrategy<JetWhenConditionInRange>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetWhenConditionInRange condition) {
            return 17.markElement(condition.getOperationReference());
        }
    };
    public static final PositioningStrategy<JetNullableType> NULLABLE_TYPE = new PositioningStrategy<JetNullableType>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetNullableType element) {
            return 18.markNode(element.getQuestionMarkNode());
        }
    };
    public static final PositioningStrategy<JetExpression> CALL_EXPRESSION = new PositioningStrategy<JetExpression>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetExpression element) {
            if (element instanceof JetCallExpression) {
                JetCallExpression callExpression = (JetCallExpression)element;
                JetTypeArgumentList typeArgumentList = callExpression.getTypeArgumentList();
                JetExpression calleeExpression = callExpression.getCalleeExpression();
                JetElement endElement = typeArgumentList != null ? typeArgumentList : (calleeExpression != null ? calleeExpression : element);
                return 19.markRange(new TextRange(element.getTextRange().getStartOffset(), endElement.getTextRange().getEndOffset()));
            }
            return super.mark(element);
        }
    };
    public static final PositioningStrategy<JetElement> VALUE_ARGUMENTS = new PositioningStrategy<JetElement>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetElement element) {
            PsiElement rightParenthesis;
            if (element instanceof JetValueArgumentList && (rightParenthesis = ((JetValueArgumentList)element).getRightParenthesis()) != null) {
                return 20.markElement(rightParenthesis);
            }
            return super.mark(element);
        }
    };
    public static final PositioningStrategy<JetFunctionLiteral> FUNCTION_LITERAL_PARAMETERS = new PositioningStrategy<JetFunctionLiteral>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetFunctionLiteral functionLiteral) {
            JetParameterList valueParameterList = functionLiteral.getValueParameterList();
            if (valueParameterList != null) {
                return 21.markElement(valueParameterList);
            }
            return 21.markNode(functionLiteral.getOpenBraceNode());
        }
    };

    public static PositioningStrategy<JetModifierListOwner> modifierSetPosition(final JetKeywordToken ... tokens) {
        return new PositioningStrategy<JetModifierListOwner>(){

            @Override
            @NotNull
            public List<TextRange> mark(@NotNull JetModifierListOwner modifierListOwner) {
                JetModifierList modifierList = modifierListOwner.getModifierList();
                assert (modifierList != null) : "No modifier list, but modifier has been found by the analyzer";
                for (JetKeywordToken token : tokens) {
                    ASTNode node = modifierList.getModifierNode(token);
                    if (node == null) continue;
                    return 7.markNode(node);
                }
                throw new IllegalStateException("None of the modifiers is found: " + Arrays.asList(tokens));
            }
        };
    }

    private PositioningStrategies() {
    }
}

