/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.parsing.JetParsing;
import org.jetbrains.jet.lang.parsing.JetScriptDefinitionProvider;
import org.jetbrains.jet.lang.parsing.SemanticWhitespaceAwarePsiBuilderImpl;

public class JetParser
implements PsiParser {
    public static final String STD_SCRIPT_EXT = ".ktscript";
    private final JetScriptDefinitionProvider scriptDefinitionProvider;

    public JetParser(Project project) {
        this.scriptDefinitionProvider = JetScriptDefinitionProvider.getInstance(project);
    }

    @Override
    @NotNull
    public ASTNode parse(IElementType iElementType, PsiBuilder psiBuilder) {
        throw new IllegalStateException("use another parse");
    }

    @NotNull
    public ASTNode parse(IElementType iElementType, PsiBuilder psiBuilder, PsiFile psiFile) {
        JetParsing jetParsing = JetParsing.createForTopLevel(new SemanticWhitespaceAwarePsiBuilderImpl(psiBuilder));
        if (this.scriptDefinitionProvider != null && this.scriptDefinitionProvider.isScript(psiFile) || psiFile.getName().endsWith(STD_SCRIPT_EXT)) {
            jetParsing.parseScript();
        } else {
            jetParsing.parseFile();
        }
        return psiBuilder.getTreeBuilt();
    }

    @NotNull
    public static ASTNode parseTypeCodeFragment(PsiBuilder psiBuilder) {
        JetParsing jetParsing = JetParsing.createForTopLevel(new SemanticWhitespaceAwarePsiBuilderImpl(psiBuilder));
        jetParsing.parseTypeCodeFragment();
        return psiBuilder.getTreeBuilt();
    }

    @NotNull
    public static ASTNode parseExpressionCodeFragment(PsiBuilder psiBuilder) {
        JetParsing jetParsing = JetParsing.createForTopLevel(new SemanticWhitespaceAwarePsiBuilderImpl(psiBuilder));
        jetParsing.parseExpressionCodeFragment();
        return psiBuilder.getTreeBuilt();
    }
}

