/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetDeclarationStub;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lexer.JetTokens;

abstract class JetNamedDeclarationStub<T extends NamedStub>
extends JetDeclarationStub<T>
implements JetNamedDeclaration {
    public JetNamedDeclarationStub(@NotNull T stub, @NotNull IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public JetNamedDeclarationStub(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public String getName() {
        NamedStub stub = (NamedStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            String text = identifier.getText();
            return text != null ? JetPsiUtil.unquoteIdentifier(text) : null;
        }
        return null;
    }

    @Override
    public Name getNameAsName() {
        String name = this.getName();
        return name != null ? Name.identifier(name) : null;
    }

    @Override
    @NotNull
    public Name getNameAsSafeName() {
        return JetPsiUtil.safeName(this.getName());
    }

    @Override
    public PsiElement getNameIdentifier() {
        return this.findChildByType(JetTokens.IDENTIFIER);
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        return this.getNameIdentifier().replace(JetPsiFactory.createNameIdentifier(this.getProject(), name));
    }

    @Override
    public int getTextOffset() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getTextRange().getStartOffset() : this.getTextRange().getStartOffset();
    }
}

