/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotated;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.AnnotationUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.constants.AnnotationValue;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.constants.JavaClassValue;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class AnnotationResolver {
    private ExpressionTypingServices expressionTypingServices;
    private CallResolver callResolver;

    public void setExpressionTypingServices(ExpressionTypingServices expressionTypingServices) {
        this.expressionTypingServices = expressionTypingServices;
    }

    public void setCallResolver(CallResolver callResolver) {
        this.callResolver = callResolver;
    }

    @NotNull
    public List<AnnotationDescriptor> resolveAnnotations(@NotNull JetScope scope, @Nullable JetModifierList modifierList, @NotNull BindingTrace trace) {
        return this.resolveAnnotations(scope, modifierList, trace, false);
    }

    @NotNull
    public List<AnnotationDescriptor> resolveAnnotationsWithArguments(@NotNull JetScope scope, @Nullable JetModifierList modifierList, @NotNull BindingTrace trace) {
        return this.resolveAnnotations(scope, modifierList, trace, true);
    }

    private List<AnnotationDescriptor> resolveAnnotations(@NotNull JetScope scope, @Nullable JetModifierList modifierList, @NotNull BindingTrace trace, boolean shouldResolveArguments) {
        if (modifierList == null) {
            return Collections.emptyList();
        }
        List<JetAnnotationEntry> annotationEntryElements = modifierList.getAnnotationEntries();
        if (annotationEntryElements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationDescriptor> result = Lists.newArrayList();
        for (JetAnnotationEntry entryElement : annotationEntryElements) {
            AnnotationDescriptor descriptor = new AnnotationDescriptor();
            this.resolveAnnotationStub(scope, entryElement, descriptor, trace);
            trace.record(BindingContext.ANNOTATION, entryElement, descriptor);
            if (shouldResolveArguments) {
                this.resolveAnnotationArguments(entryElement, scope, trace);
            }
            result.add(descriptor);
        }
        return result;
    }

    public void resolveAnnotationStub(@NotNull JetScope scope, @NotNull JetAnnotationEntry entryElement, @NotNull AnnotationDescriptor annotationDescriptor, @NotNull BindingTrace trace) {
        TemporaryBindingTrace temporaryBindingTrace = new TemporaryBindingTrace(trace, "Trace for resolve annotation type");
        OverloadResolutionResults<FunctionDescriptor> results = this.resolveAnnotationCall(entryElement, scope, temporaryBindingTrace);
        if (results.isSuccess()) {
            FunctionDescriptor descriptor = results.getResultingDescriptor();
            if (!ErrorUtils.isError(descriptor)) {
                if (descriptor instanceof ConstructorDescriptor) {
                    ConstructorDescriptor constructor = (ConstructorDescriptor)descriptor;
                    ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
                    if (classDescriptor.getKind() != ClassKind.ANNOTATION_CLASS) {
                        trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, classDescriptor.getName().asString()));
                    }
                } else {
                    trace.report(Errors.NOT_AN_ANNOTATION_CLASS.on(entryElement, descriptor.getName().asString()));
                }
            }
            JetType annotationType = results.getResultingDescriptor().getReturnType();
            annotationDescriptor.setAnnotationType(annotationType);
        } else {
            annotationDescriptor.setAnnotationType(ErrorUtils.createErrorType("Unresolved annotation type"));
        }
    }

    private OverloadResolutionResults<FunctionDescriptor> resolveAnnotationCall(JetAnnotationEntry annotationEntry, JetScope scope, BindingTrace trace) {
        return this.callResolver.resolveFunctionCall(trace, scope, CallMaker.makeCall(ReceiverValue.NO_RECEIVER, null, annotationEntry), TypeUtils.NO_EXPECTED_TYPE, DataFlowInfo.EMPTY);
    }

    public void resolveAnnotationsArguments(@NotNull JetScope scope, @Nullable JetModifierList modifierList, @NotNull BindingTrace trace) {
        if (modifierList == null) {
            return;
        }
        for (JetAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            this.resolveAnnotationArguments(annotationEntry, scope, trace);
        }
    }

    public void resolveAnnotationsArguments(@NotNull Annotated descriptor, @NotNull BindingTrace trace, @NotNull JetScope scope) {
        for (AnnotationDescriptor annotationDescriptor : descriptor.getAnnotations()) {
            JetAnnotationEntry annotationEntry = trace.getBindingContext().get(BindingContext.ANNOTATION_DESCRIPTOR_TO_PSI_ELEMENT, annotationDescriptor);
            assert (annotationEntry != null) : "Cannot find annotation entry: " + annotationDescriptor;
            this.resolveAnnotationArguments(annotationEntry, scope, trace);
        }
    }

    private void resolveAnnotationArguments(@NotNull JetAnnotationEntry annotationEntry, @NotNull JetScope scope, @NotNull BindingTrace trace) {
        OverloadResolutionResults<FunctionDescriptor> results = this.resolveAnnotationCall(annotationEntry, scope, trace);
        if (results.isSuccess()) {
            AnnotationDescriptor annotationDescriptor = trace.getBindingContext().get(BindingContext.ANNOTATION, annotationEntry);
            assert (annotationDescriptor != null) : "Annotation descriptor should be created before resolving arguments for " + annotationEntry.getText();
            this.resolveAnnotationArgument(annotationDescriptor, results.getResultingCall(), trace);
        }
    }

    private void resolveAnnotationArgument(@NotNull AnnotationDescriptor annotationDescriptor, @NotNull ResolvedCall<? extends CallableDescriptor> call, @NotNull BindingTrace trace) {
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> descriptorToArgument : call.getValueArguments().entrySet()) {
            ValueParameterDescriptor parameterDescriptor = descriptorToArgument.getKey();
            JetType varargElementType = parameterDescriptor.getVarargElementType();
            List<CompileTimeConstant<?>> constants = this.resolveValueArguments(descriptorToArgument.getValue(), parameterDescriptor.getType(), trace);
            if (varargElementType == null) {
                for (CompileTimeConstant<?> constant : constants) {
                    annotationDescriptor.setValueArgument(parameterDescriptor, constant);
                }
                continue;
            }
            JetType arrayType = KotlinBuiltIns.getInstance().getPrimitiveArrayJetTypeByPrimitiveJetType(varargElementType);
            if (arrayType == null) {
                arrayType = KotlinBuiltIns.getInstance().getArrayType(varargElementType);
            }
            annotationDescriptor.setValueArgument(parameterDescriptor, new ArrayValue(constants, arrayType));
        }
    }

    @NotNull
    private List<CompileTimeConstant<?>> resolveValueArguments(@NotNull ResolvedValueArgument resolvedValueArgument, @NotNull JetType expectedType, @NotNull BindingTrace trace) {
        ArrayList<CompileTimeConstant<?>> constants = Lists.newArrayList();
        for (ValueArgument argument : resolvedValueArgument.getArguments()) {
            CompileTimeConstant<?> constant;
            JetExpression argumentExpression = argument.getArgumentExpression();
            if (argumentExpression == null || (constant = this.resolveAnnotationArgument(argumentExpression, expectedType, trace)) == null) continue;
            constants.add(constant);
        }
        return constants;
    }

    @Nullable
    private CompileTimeConstant<?> resolveAnnotationArgument(@NotNull JetExpression expression, final @NotNull JetType expectedType, final BindingTrace trace) {
        JetVisitor visitor = new JetVisitor<CompileTimeConstant<?>, Void>(){

            @Override
            public CompileTimeConstant<?> visitConstantExpression(JetConstantExpression expression, Void nothing) {
                JetType type = AnnotationResolver.this.expressionTypingServices.getType(JetScope.EMPTY, expression, expectedType, DataFlowInfo.EMPTY, trace);
                if (type == null) {
                    // empty if block
                }
                return trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
            }

            @Override
            public CompileTimeConstant<?> visitParenthesizedExpression(JetParenthesizedExpression expression, Void nothing) {
                JetExpression innerExpression = expression.getExpression();
                if (innerExpression == null) {
                    return null;
                }
                return (CompileTimeConstant)innerExpression.accept(this, null);
            }

            @Override
            public CompileTimeConstant<?> visitStringTemplateExpression(JetStringTemplateExpression expression, Void nothing) {
                return trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
            }

            @Override
            public CompileTimeConstant<?> visitSimpleNameExpression(JetSimpleNameExpression expression, Void data) {
                PropertyDescriptor propertyDescriptor;
                CallableDescriptor callableDescriptor;
                ResolvedCall<? extends CallableDescriptor> resolvedCall = trace.getBindingContext().get(BindingContext.RESOLVED_CALL, expression);
                if (resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) instanceof PropertyDescriptor && AnnotationResolver.isEnumProperty(propertyDescriptor = (PropertyDescriptor)callableDescriptor)) {
                    return new EnumValue(propertyDescriptor);
                }
                return null;
            }

            @Override
            public CompileTimeConstant<?> visitQualifiedExpression(JetQualifiedExpression expression, Void data) {
                JetExpression selectorExpression = expression.getSelectorExpression();
                if (selectorExpression != null) {
                    return (CompileTimeConstant)selectorExpression.accept(this, null);
                }
                return (CompileTimeConstant)super.visitQualifiedExpression(expression, data);
            }

            @Override
            public CompileTimeConstant<?> visitCallExpression(JetCallExpression expression, Void data) {
                ResolvedCall<? extends CallableDescriptor> call = trace.getBindingContext().get(BindingContext.RESOLVED_CALL, expression.getCalleeExpression());
                if (call != null) {
                    CallableDescriptor resultingDescriptor = call.getResultingDescriptor();
                    if (AnnotationUtils.isArrayMethodCall(call)) {
                        JetType type = resultingDescriptor.getValueParameters().iterator().next().getVarargElementType();
                        ArrayList<CompileTimeConstant<?>> arguments = Lists.newArrayList();
                        for (ResolvedValueArgument descriptorToArgument : call.getValueArguments().values()) {
                            arguments.addAll(AnnotationResolver.this.resolveValueArguments(descriptorToArgument, type, trace));
                        }
                        return new ArrayValue(arguments, resultingDescriptor.getReturnType());
                    }
                    if (resultingDescriptor instanceof ConstructorDescriptor) {
                        JetType constructorReturnType = resultingDescriptor.getReturnType();
                        assert (constructorReturnType != null) : "Constructor should have return type";
                        if (DescriptorUtils.isAnnotationClass(constructorReturnType.getConstructor().getDeclarationDescriptor())) {
                            AnnotationDescriptor descriptor = new AnnotationDescriptor();
                            descriptor.setAnnotationType(constructorReturnType);
                            AnnotationResolver.this.resolveAnnotationArgument(descriptor, call, trace);
                            return new AnnotationValue(descriptor);
                        }
                    }
                    if (AnnotationUtils.isJavaClassMethodCall(call)) {
                        return new JavaClassValue(resultingDescriptor.getReturnType());
                    }
                }
                return null;
            }

            @Override
            public CompileTimeConstant<?> visitJetElement(JetElement element, Void nothing) {
                return null;
            }
        };
        return (CompileTimeConstant)expression.accept(visitor, null);
    }

    private static boolean isEnumProperty(@NotNull PropertyDescriptor descriptor) {
        DeclarationDescriptor enumClassObject;
        if (DescriptorUtils.isKindOf(descriptor.getType(), ClassKind.ENUM_CLASS) && DescriptorUtils.isKindOf(enumClassObject = descriptor.getContainingDeclaration(), ClassKind.CLASS_OBJECT)) {
            return DescriptorUtils.isKindOf(enumClassObject.getContainingDeclaration(), ClassKind.ENUM_CLASS);
        }
        return false;
    }

    @NotNull
    public List<AnnotationDescriptor> getResolvedAnnotations(@Nullable JetModifierList modifierList, BindingTrace trace) {
        if (modifierList == null) {
            return Collections.emptyList();
        }
        return this.getResolvedAnnotations(modifierList.getAnnotationEntries(), trace);
    }

    @NotNull
    public List<AnnotationDescriptor> getResolvedAnnotations(List<JetAnnotationEntry> annotations, BindingTrace trace) {
        ArrayList<AnnotationDescriptor> result = Lists.newArrayList();
        for (JetAnnotationEntry annotation : annotations) {
            AnnotationDescriptor annotationDescriptor = trace.get(BindingContext.ANNOTATION, annotation);
            if (annotationDescriptor == null) {
                annotationDescriptor = new AnnotationDescriptor();
                annotationDescriptor.setAnnotationType(ErrorUtils.createErrorType("Unresolved annotation type"));
                trace.record(BindingContext.ANNOTATION, annotation, annotationDescriptor);
            }
            result.add(annotationDescriptor);
        }
        return result;
    }
}

