/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.context.ExpressionPosition;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;

public class ScriptBodyResolver {
    @NotNull
    private TopDownAnalysisContext context;
    @NotNull
    private ExpressionTypingServices expressionTypingServices;
    @NotNull
    private BindingTrace trace;

    public void setContext(@NotNull TopDownAnalysisContext context) {
        this.context = context;
    }

    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        this.expressionTypingServices = expressionTypingServices;
    }

    public void setTrace(@NotNull BindingTrace trace) {
        this.trace = trace;
    }

    public void resolveScriptBodies() {
        for (Map.Entry<JetScript, ScriptDescriptor> e : this.context.getScripts().entrySet()) {
            JetScript declaration = e.getKey();
            ScriptDescriptor descriptor = e.getValue();
            WritableScope scope = this.context.getScriptScopes().get(declaration);
            scope.changeLockLevel(WritableScope.LockLevel.READING);
            ExpressionTypingContext context = ExpressionTypingContext.newContext(this.expressionTypingServices, this.trace, scope, DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE, ExpressionPosition.FREE);
            JetType returnType = this.expressionTypingServices.getBlockReturnedType(scope, declaration.getBlockExpression(), CoercionStrategy.NO_COERCION, context, this.trace).getType();
            if (returnType == null) {
                returnType = ErrorUtils.createErrorType("getBlockReturnedType returned null");
            }
            descriptor.initialize(returnType, declaration, this.trace.getBindingContext());
        }
    }
}

