/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kt;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.java.kt.PsiAnnotationWithFlags;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;

public class JetMethodAnnotation
extends PsiAnnotationWithFlags {
    private static final JetMethodAnnotation NULL_ANNOTATION = new JetMethodAnnotation(null);
    private String typeParameters;
    private String returnType;
    private String propertyType;

    private JetMethodAnnotation(@Nullable PsiAnnotation psiAnnotation) {
        super(psiAnnotation);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.typeParameters = this.getStringAttribute("typeParameters", "");
        this.returnType = this.getStringAttribute("returnType", "");
        this.propertyType = this.getStringAttribute("propertyType", "");
    }

    public int kind() {
        return this.flags() & 0x1C0;
    }

    @NotNull
    public String typeParameters() {
        this.checkInitialized();
        return this.typeParameters;
    }

    @NotNull
    public String returnType() {
        this.checkInitialized();
        return this.returnType;
    }

    @NotNull
    public String propertyType() {
        this.checkInitialized();
        return this.propertyType;
    }

    public static JetMethodAnnotation get(PsiMethod psiMethod) {
        PsiAnnotation annotation = JavaAnnotationResolver.findOwnAnnotation(psiMethod, JvmStdlibNames.JET_METHOD.getFqName().asString());
        return annotation != null ? new JetMethodAnnotation(annotation) : NULL_ANNOTATION;
    }

    static {
        NULL_ANNOTATION.checkInitialized();
    }
}

