/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kt;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAnnotationUtils {
    private PsiAnnotationUtils() {
    }

    @NotNull
    public static String getStringAttribute(@Nullable PsiAnnotation annotation, @NotNull String field, @NotNull String defaultValue) {
        return PsiAnnotationUtils.getAttribute(annotation, field, defaultValue);
    }

    public static boolean getBooleanAttribute(@Nullable PsiAnnotation annotation, @NotNull String field, boolean defaultValue) {
        return PsiAnnotationUtils.getAttribute(annotation, field, defaultValue);
    }

    public static int getIntAttribute(@Nullable PsiAnnotation annotation, @NotNull String field, int defaultValue) {
        return PsiAnnotationUtils.getAttribute(annotation, field, defaultValue);
    }

    @NotNull
    private static <T> T getAttribute(@Nullable PsiAnnotation annotation, @NotNull String field, @NotNull T defaultValue) {
        if (annotation == null) {
            return defaultValue;
        }
        PsiAnnotationMemberValue value = annotation.findAttributeValue(field);
        if (value instanceof PsiLiteralExpression) {
            PsiLiteralExpression attributeValue = (PsiLiteralExpression)value;
            return (T)attributeValue.getValue();
        }
        return defaultValue;
    }
}

