/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.declarations;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.openapi.util.Computable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetTypedef;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.jet.lang.resolve.lazy.declarations.DeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.Name;

public abstract class AbstractPsiBasedDeclarationProvider
implements DeclarationProvider {
    private final NotNullLazyValue<Index> index;

    public AbstractPsiBasedDeclarationProvider(@NotNull StorageManager storageManager) {
        this.index = storageManager.createLazyValue(new Computable<Index>(){

            @Override
            public Index compute() {
                Index index = new Index();
                AbstractPsiBasedDeclarationProvider.this.doCreateIndex(index);
                return index;
            }
        });
    }

    protected abstract void doCreateIndex(@NotNull Index var1);

    @Override
    public List<JetDeclaration> getAllDeclarations() {
        return this.index.compute().allDeclarations;
    }

    @NotNull
    public List<JetNamedFunction> getFunctionDeclarations(@NotNull Name name) {
        return Lists.newArrayList(this.index.compute().functions.get(name));
    }

    @NotNull
    public List<JetProperty> getPropertyDeclarations(@NotNull Name name) {
        return Lists.newArrayList(this.index.compute().properties.get(name));
    }

    @Override
    @NotNull
    public Collection<JetClassOrObject> getClassOrObjectDeclarations(@NotNull Name name) {
        return this.index.compute().classesAndObjects.get(name);
    }

    protected static class Index {
        private final List<JetDeclaration> allDeclarations = Lists.newArrayList();
        private final Multimap<Name, JetNamedFunction> functions = HashMultimap.create();
        private final Multimap<Name, JetProperty> properties = HashMultimap.create();
        private final Multimap<Name, JetClassOrObject> classesAndObjects = ArrayListMultimap.create();

        protected Index() {
        }

        public void putToIndex(@NotNull JetDeclaration declaration) {
            if (declaration instanceof JetClassInitializer) {
                return;
            }
            this.allDeclarations.add(declaration);
            if (declaration instanceof JetNamedFunction) {
                JetNamedFunction namedFunction = (JetNamedFunction)declaration;
                this.functions.put(ResolveSessionUtils.safeNameForLazyResolve(namedFunction), namedFunction);
            } else if (declaration instanceof JetProperty) {
                JetProperty property = (JetProperty)declaration;
                this.properties.put(ResolveSessionUtils.safeNameForLazyResolve(property), property);
            } else if (declaration instanceof JetClassOrObject) {
                JetClassOrObject classOrObject = (JetClassOrObject)declaration;
                this.classesAndObjects.put(ResolveSessionUtils.safeNameForLazyResolve(classOrObject.getNameAsName()), classOrObject);
            } else if (!(declaration instanceof JetParameter || declaration instanceof JetTypedef || declaration instanceof JetMultiDeclaration)) {
                throw new IllegalArgumentException("Unknown declaration: " + declaration);
            }
        }
    }
}

