/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallExpressionResolver;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.context.ExpressionPosition;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingFacade;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitorDispatcher;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

public class ExpressionTypingServices {
    private final ExpressionTypingFacade expressionTypingFacade = ExpressionTypingVisitorDispatcher.create();
    @NotNull
    private Project project;
    @NotNull
    private CallResolver callResolver;
    @NotNull
    private CallExpressionResolver callExpressionResolver;
    @NotNull
    private DescriptorResolver descriptorResolver;
    @NotNull
    private TypeResolver typeResolver;

    @NotNull
    public Project getProject() {
        return this.project;
    }

    public void setProject(@NotNull Project project) {
        this.project = project;
    }

    @NotNull
    public CallResolver getCallResolver() {
        return this.callResolver;
    }

    public void setCallResolver(@NotNull CallResolver callResolver) {
        this.callResolver = callResolver;
    }

    @NotNull
    public CallExpressionResolver getCallExpressionResolver() {
        return this.callExpressionResolver;
    }

    public void setCallExpressionResolver(@NotNull CallExpressionResolver callExpressionResolver) {
        this.callExpressionResolver = callExpressionResolver;
    }

    @NotNull
    public DescriptorResolver getDescriptorResolver() {
        return this.descriptorResolver;
    }

    public void setDescriptorResolver(@NotNull DescriptorResolver descriptorResolver) {
        this.descriptorResolver = descriptorResolver;
    }

    @NotNull
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @NotNull
    public JetType safeGetType(@NotNull JetScope scope, @NotNull JetExpression expression, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        JetType type = this.getType(scope, expression, expectedType, dataFlowInfo, trace);
        if (type != null) {
            return type;
        }
        return ErrorUtils.createErrorType("Type for " + expression.getText());
    }

    @NotNull
    public JetTypeInfo getTypeInfo(@NotNull JetScope scope, @NotNull JetExpression expression, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        ExpressionTypingContext context = ExpressionTypingContext.newContext(this, trace, scope, dataFlowInfo, expectedType, ExpressionPosition.FREE);
        return this.expressionTypingFacade.getTypeInfo(expression, context);
    }

    @Nullable
    public JetType getType(@NotNull JetScope scope, @NotNull JetExpression expression, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        return this.getTypeInfo(scope, expression, expectedType, dataFlowInfo, trace).getType();
    }

    public JetTypeInfo getTypeInfoWithNamespaces(@NotNull JetExpression expression, @NotNull JetScope scope, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        ExpressionTypingContext context = ExpressionTypingContext.newContext(this, trace, scope, dataFlowInfo, expectedType, ExpressionPosition.LHS_OF_DOT);
        return this.expressionTypingFacade.getTypeInfo(expression, context);
    }

    @NotNull
    public JetType inferFunctionReturnType(@NotNull JetScope outerScope, @NotNull JetDeclarationWithBody function, @NotNull FunctionDescriptor functionDescriptor, @NotNull BindingTrace trace) {
        Map<JetExpression, JetType> typeMap = this.collectReturnedExpressionsWithTypes(trace, outerScope, function, functionDescriptor);
        Collection<JetType> types = typeMap.values();
        return types.isEmpty() ? KotlinBuiltIns.getInstance().getNothingType() : CommonSupertypes.commonSupertype(types);
    }

    public void checkFunctionReturnType(@NotNull JetScope functionInnerScope, @NotNull JetDeclarationWithBody function, @NotNull FunctionDescriptor functionDescriptor, @NotNull DataFlowInfo dataFlowInfo, @Nullable JetType expectedReturnType, BindingTrace trace) {
        if (expectedReturnType == null) {
            expectedReturnType = functionDescriptor.getReturnType();
            if (!function.hasBlockBody() && !function.hasDeclaredReturnType()) {
                expectedReturnType = TypeUtils.NO_EXPECTED_TYPE;
            }
        }
        this.checkFunctionReturnType(function, ExpressionTypingContext.newContext(this, trace, functionInnerScope, dataFlowInfo, expectedReturnType != null ? expectedReturnType : TypeUtils.NO_EXPECTED_TYPE, ExpressionPosition.FREE), trace);
    }

    void checkFunctionReturnType(JetDeclarationWithBody function, ExpressionTypingContext context, BindingTrace trace) {
        ExpressionTypingContext newContext;
        JetExpression bodyExpression = function.getBodyExpression();
        if (bodyExpression == null) {
            return;
        }
        boolean blockBody = function.hasBlockBody();
        ExpressionTypingContext expressionTypingContext = newContext = blockBody ? (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE) : context;
        if (function instanceof JetFunctionLiteral) {
            JetFunctionLiteral functionLiteral = (JetFunctionLiteral)function;
            JetBlockExpression blockExpression = functionLiteral.getBodyExpression();
            assert (blockExpression != null);
            this.getBlockReturnedType(newContext.scope, blockExpression, CoercionStrategy.COERCION_TO_UNIT, context, trace);
        } else {
            this.expressionTypingFacade.getTypeInfo(bodyExpression, newContext, !blockBody);
        }
    }

    @NotNull
    public JetTypeInfo getBlockReturnedType(@NotNull JetScope outerScope, @NotNull JetBlockExpression expression, @NotNull CoercionStrategy coercionStrategyForLastExpression, ExpressionTypingContext context, BindingTrace trace) {
        List<JetElement> block = expression.getStatements();
        DeclarationDescriptor containingDescriptor = outerScope.getContainingDeclaration();
        if (containingDescriptor instanceof ScriptDescriptor && !(expression.getParent() instanceof JetScript)) {
            containingDescriptor = ((ScriptDescriptor)containingDescriptor).getScriptCodeDescriptor();
        }
        WritableScopeImpl scope = new WritableScopeImpl(outerScope, containingDescriptor, new TraceBasedRedeclarationHandler(context.trace), "getBlockReturnedType");
        scope.changeLockLevel(WritableScope.LockLevel.BOTH);
        JetTypeInfo r = block.isEmpty() ? DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getUnitType(), expression, context, context.dataFlowInfo) : this.getBlockReturnedTypeWithWritableScope(scope, block, coercionStrategyForLastExpression, context, trace);
        scope.changeLockLevel(WritableScope.LockLevel.READING);
        if (containingDescriptor instanceof ScriptDescriptor) {
            trace.record(BindingContext.SCRIPT_SCOPE, (ScriptDescriptor)containingDescriptor, scope);
        }
        return r;
    }

    private Map<JetExpression, JetType> collectReturnedExpressionsWithTypes(final @NotNull BindingTrace trace, JetScope outerScope, final JetDeclarationWithBody function, FunctionDescriptor functionDescriptor) {
        JetExpression bodyExpression = function.getBodyExpression();
        assert (bodyExpression != null);
        JetScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(outerScope, functionDescriptor, trace);
        this.expressionTypingFacade.getTypeInfo(bodyExpression, ExpressionTypingContext.newContext(this, trace, functionInnerScope, DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE, ExpressionPosition.FREE), !function.hasBlockBody());
        final ArrayList<JetExpression> returnedExpressions = Lists.newArrayList();
        if (function.hasBlockBody()) {
            bodyExpression.accept(new JetTreeVisitor<JetDeclarationWithBody>(){

                @Override
                public Void visitReturnExpression(JetReturnExpression expression, JetDeclarationWithBody outerFunction) {
                    PsiElement element;
                    JetSimpleNameExpression targetLabel = expression.getTargetLabel();
                    PsiElement psiElement = element = targetLabel != null ? trace.get(BindingContext.LABEL_TARGET, targetLabel) : null;
                    if (element == function || targetLabel == null && outerFunction == function) {
                        returnedExpressions.add(expression);
                    }
                    return null;
                }

                @Override
                public Void visitFunctionLiteralExpression(JetFunctionLiteralExpression expression, JetDeclarationWithBody outerFunction) {
                    return (Void)super.visitFunctionLiteralExpression(expression, expression.getFunctionLiteral());
                }

                @Override
                public Void visitNamedFunction(JetNamedFunction function2, JetDeclarationWithBody outerFunction) {
                    return (Void)super.visitNamedFunction(function2, function2);
                }
            }, function);
        } else {
            returnedExpressions.add(bodyExpression);
        }
        HashMap<JetExpression, JetType> typeMap = new HashMap<JetExpression, JetType>();
        for (JetExpression returnedExpression : returnedExpressions) {
            JetType cachedType = trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, returnedExpression);
            trace.record(BindingContext.STATEMENT, returnedExpression, false);
            if (cachedType != null) {
                typeMap.put(returnedExpression, cachedType);
                continue;
            }
            typeMap.put(returnedExpression, ErrorUtils.createErrorType("Error function type"));
        }
        return typeMap;
    }

    JetTypeInfo getBlockReturnedTypeWithWritableScope(@NotNull WritableScope scope, @NotNull List<? extends JetElement> block, @NotNull CoercionStrategy coercionStrategyForLastExpression, ExpressionTypingContext context, BindingTrace trace) {
        if (block.isEmpty()) {
            return JetTypeInfo.create(KotlinBuiltIns.getInstance().getUnitType(), context.dataFlowInfo);
        }
        ExpressionTypingInternals blockLevelVisitor = ExpressionTypingVisitorDispatcher.createForBlock(scope);
        ExpressionTypingContext newContext = this.createContext(context, trace, scope, context.dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE);
        JetTypeInfo result = JetTypeInfo.create(null, context.dataFlowInfo);
        Iterator<? extends JetElement> iterator = block.iterator();
        while (iterator.hasNext()) {
            JetElement statement = iterator.next();
            if (!(statement instanceof JetExpression)) continue;
            trace.record(BindingContext.STATEMENT, statement);
            JetExpression statementExpression = (JetExpression)statement;
            if (!iterator.hasNext()) {
                if (context.expectedType != TypeUtils.NO_EXPECTED_TYPE) {
                    if (coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT && KotlinBuiltIns.getInstance().isUnit(context.expectedType)) {
                        TemporaryBindingTrace temporaryTraceExpectingUnit = TemporaryBindingTrace.create(trace, "trace to resolve coercion to unit with expected type");
                        boolean[] mismatch = new boolean[1];
                        ObservableBindingTrace errorInterceptingTrace = ExpressionTypingUtils.makeTraceInterceptingTypeMismatch(temporaryTraceExpectingUnit, statementExpression, mismatch);
                        newContext = this.createContext(newContext, errorInterceptingTrace, scope, newContext.dataFlowInfo, context.expectedType);
                        result = blockLevelVisitor.getTypeInfo(statementExpression, newContext, true);
                        if (mismatch[0]) {
                            TemporaryBindingTrace temporaryTraceNoExpectedType = TemporaryBindingTrace.create(trace, "trace to resolve coercion to unit without expected type");
                            mismatch[0] = false;
                            ObservableBindingTrace interceptingTrace = ExpressionTypingUtils.makeTraceInterceptingTypeMismatch(temporaryTraceNoExpectedType, statementExpression, mismatch);
                            newContext = this.createContext(newContext, interceptingTrace, scope, newContext.dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE);
                            result = blockLevelVisitor.getTypeInfo(statementExpression, newContext, true);
                            if (mismatch[0]) {
                                temporaryTraceExpectingUnit.commit();
                            } else {
                                temporaryTraceNoExpectedType.commit();
                            }
                        } else {
                            temporaryTraceExpectingUnit.commit();
                        }
                    } else {
                        newContext = this.createContext(newContext, trace, scope, newContext.dataFlowInfo, context.expectedType);
                        result = blockLevelVisitor.getTypeInfo(statementExpression, newContext, true);
                    }
                } else {
                    result = blockLevelVisitor.getTypeInfo(statementExpression, newContext, true);
                    if (coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT) {
                        JetBinaryExpression binaryExpression;
                        IElementType operationType;
                        boolean mightBeUnit = false;
                        if (statementExpression instanceof JetDeclaration) {
                            mightBeUnit = true;
                        }
                        if (statementExpression instanceof JetBinaryExpression && ((operationType = (binaryExpression = (JetBinaryExpression)statementExpression).getOperationToken()) == JetTokens.EQ || OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType))) {
                            mightBeUnit = true;
                        }
                        if (mightBeUnit) {
                            assert (result.getType() == null || KotlinBuiltIns.getInstance().isUnit(result.getType()));
                            result = JetTypeInfo.create(KotlinBuiltIns.getInstance().getUnitType(), newContext.dataFlowInfo);
                        }
                    }
                }
            } else {
                result = blockLevelVisitor.getTypeInfo(statementExpression, newContext, true);
            }
            DataFlowInfo newDataFlowInfo = result.getDataFlowInfo();
            if (newDataFlowInfo != context.dataFlowInfo) {
                newContext = this.createContext(newContext, trace, scope, newDataFlowInfo, TypeUtils.NO_EXPECTED_TYPE);
            }
            blockLevelVisitor = ExpressionTypingVisitorDispatcher.createForBlock(scope);
        }
        return result;
    }

    private ExpressionTypingContext createContext(ExpressionTypingContext oldContext, BindingTrace trace, WritableScope scope, DataFlowInfo dataFlowInfo, JetType expectedType) {
        return ExpressionTypingContext.newContext(this, oldContext.labelResolver, trace, scope, dataFlowInfo, expectedType, oldContext.expressionPosition);
    }

    @Nullable
    public JetExpression deparenthesize(@NotNull JetExpression expression, final @NotNull ExpressionTypingContext context) {
        return JetPsiUtil.deparenthesizeWithResolutionStrategy(expression, new Function<JetTypeReference, Void>(){

            @Override
            public Void apply(JetTypeReference reference) {
                ExpressionTypingServices.this.getTypeResolver().resolveType(context.scope, reference, context.trace, true);
                return null;
            }
        });
    }
}

