/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassDeclarationTranslator;
import org.jetbrains.k2js.translate.declaration.DeclarationBodyVisitor;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.initializer.InitializerUtils;
import org.jetbrains.k2js.translate.initializer.InitializerVisitor;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

final class NamespaceTranslator
extends AbstractTranslator {
    @NotNull
    private final NamespaceDescriptor descriptor;
    @NotNull
    private final ClassDeclarationTranslator classDeclarationTranslator;
    private final FileDeclarationVisitor visitor;

    NamespaceTranslator(@NotNull NamespaceDescriptor descriptor, @NotNull ClassDeclarationTranslator classDeclarationTranslator, @NotNull TranslationContext context) {
        super(context.newDeclaration(descriptor));
        this.descriptor = descriptor;
        this.classDeclarationTranslator = classDeclarationTranslator;
        this.visitor = new FileDeclarationVisitor();
    }

    public void translate(JetFile file) {
        for (JetDeclaration declaration : file.getDeclarations()) {
            if (AnnotationsUtils.isPredefinedObject(BindingUtils.getDescriptorForElement(this.bindingContext(), declaration))) continue;
            declaration.accept(this.visitor, this.context());
        }
    }

    public void add(@NotNull Map<NamespaceDescriptor, List<JsExpression>> descriptorToDefineInvocation, @NotNull List<JsStatement> initializers) {
        JsFunction initializer;
        if (this.visitor.initializerStatements.isEmpty()) {
            initializer = null;
        } else {
            initializer = this.visitor.initializer;
            if (!this.context().isEcma5()) {
                initializers.add(new JsInvocation((JsExpression)new JsNameRef("call", (JsExpression)initializer), (JsExpression)TranslationUtils.getQualifiedReference(this.context(), this.descriptor)).makeStmt());
            }
        }
        List<JsExpression> defineInvocation = descriptorToDefineInvocation.get(this.descriptor);
        if (defineInvocation == null) {
            defineInvocation = this.createDefineInvocation(initializer, new JsObjectLiteral(this.visitor.getResult(), true));
            descriptorToDefineInvocation.put(this.descriptor, defineInvocation);
            this.addToParent((NamespaceDescriptor)this.descriptor.getContainingDeclaration(), this.getEntry(this.descriptor, defineInvocation), descriptorToDefineInvocation);
        } else {
            if (this.context().isEcma5() && initializer != null) {
                assert (defineInvocation.get(0) == JsLiteral.NULL);
                defineInvocation.set(0, initializer);
            }
            ((JsObjectLiteral)defineInvocation.get(this.context().isEcma5() ? 1 : 0)).getPropertyInitializers().addAll(this.visitor.getResult());
        }
    }

    private List<JsExpression> createDefineInvocation(@Nullable JsExpression initializer, @NotNull JsObjectLiteral members) {
        if (this.context().isEcma5()) {
            return Arrays.asList(initializer == null ? JsLiteral.NULL : initializer, members);
        }
        return Collections.singletonList(members);
    }

    private JsPropertyInitializer getEntry(@NotNull NamespaceDescriptor descriptor, List<JsExpression> defineInvocation) {
        return new JsPropertyInitializer(this.context().getNameForDescriptor(descriptor).makeRef(), new JsInvocation(this.context().namer().packageDefinitionMethodReference(), defineInvocation));
    }

    private boolean addEntryIfParentExists(NamespaceDescriptor parentDescriptor, JsPropertyInitializer entry, Map<NamespaceDescriptor, List<JsExpression>> descriptorToDeclarationPlace) {
        List<JsExpression> parentDefineInvocation = descriptorToDeclarationPlace.get(parentDescriptor);
        if (parentDefineInvocation != null) {
            ((JsObjectLiteral)parentDefineInvocation.get(this.context().isEcma5() ? 1 : 0)).getPropertyInitializers().add(entry);
            return true;
        }
        return false;
    }

    private void addToParent(NamespaceDescriptor parentDescriptor, JsPropertyInitializer entry, Map<NamespaceDescriptor, List<JsExpression>> descriptorToDefineInvocation) {
        while (!this.addEntryIfParentExists(parentDescriptor, entry, descriptorToDefineInvocation)) {
            List<JsExpression> defineInvocation = this.createDefineInvocation(null, new JsObjectLiteral(new SmartList<JsPropertyInitializer>(entry), true));
            entry = this.getEntry(parentDescriptor, defineInvocation);
            descriptorToDefineInvocation.put(parentDescriptor, defineInvocation);
            parentDescriptor = (NamespaceDescriptor)parentDescriptor.getContainingDeclaration();
        }
    }

    private class FileDeclarationVisitor
    extends DeclarationBodyVisitor {
        private final JsFunction initializer;
        private final TranslationContext initializerContext;
        private final List<JsStatement> initializerStatements;
        private final InitializerVisitor initializerVisitor;

        private FileDeclarationVisitor() {
            this.initializer = JsAstUtils.createFunctionWithEmptyBody(NamespaceTranslator.this.context().scope());
            this.initializerContext = NamespaceTranslator.this.context().contextWithScope(this.initializer);
            this.initializerStatements = this.initializer.getBody().getStatements();
            this.initializerVisitor = new InitializerVisitor(this.initializerStatements);
        }

        @Override
        public Void visitClass(@NotNull JetClass expression, @NotNull TranslationContext context) {
            JsPropertyInitializer value = NamespaceTranslator.this.classDeclarationTranslator.translate(expression);
            this.result.add(value);
            return null;
        }

        @Override
        public Void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, @NotNull TranslationContext context) {
            InitializerUtils.generate(declaration, this.initializerStatements, this.result, context);
            return null;
        }

        @Override
        public Void visitProperty(@NotNull JetProperty property, @NotNull TranslationContext context) {
            super.visitProperty(property, context);
            JetExpression initializer = property.getInitializer();
            if (initializer != null) {
                JsExpression value = Translation.translateAsExpression(initializer, this.initializerContext);
                PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptor(context.bindingContext(), property);
                if (value instanceof JsLiteral) {
                    this.result.add(new JsPropertyInitializer(context.getNameForDescriptor(propertyDescriptor).makeRef(), NamespaceTranslator.this.context().isEcma5() ? JsAstUtils.createPropertyDataDescriptor(propertyDescriptor, value) : value));
                } else {
                    this.initializerStatements.add(InitializerUtils.generateInitializerForProperty(context, propertyDescriptor, value));
                }
            }
            return null;
        }

        @Override
        public Void visitAnonymousInitializer(@NotNull JetClassInitializer expression, @NotNull TranslationContext context) {
            expression.accept(this.initializerVisitor, this.initializerContext);
            return null;
        }
    }
}

