/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.utils.closure.ClosureContext;
import org.jetbrains.k2js.translate.utils.closure.ClosureUtils;

abstract class InnerDeclarationTranslator {
    protected final ClosureContext closureContext;
    protected final TranslationContext context;
    protected final JsFunction fun;

    public InnerDeclarationTranslator(@NotNull JetElement declaration, @NotNull DeclarationDescriptor descriptor, @NotNull TranslationContext context, @NotNull JsFunction fun) {
        this.context = context;
        this.closureContext = ClosureUtils.captureClosure(context.bindingContext(), declaration, descriptor);
        this.fun = fun;
    }

    protected List<ValueParameterDescriptor> getValueParameters() {
        return Collections.emptyList();
    }

    @NotNull
    public abstract JsExpression translate(@NotNull JsNameRef var1);

    protected JsExpression translate(@NotNull JsNameRef nameRef, @Nullable JsExpression self) {
        if (this.closureContext.getDescriptors().isEmpty() && self == JsLiteral.NULL) {
            return this.createExpression(nameRef, self);
        }
        JsInvocation invocation = this.createInvocation(nameRef, self);
        this.addCapturedValueParameters(invocation);
        return invocation;
    }

    protected abstract JsExpression createExpression(JsNameRef var1, JsExpression var2);

    protected abstract JsInvocation createInvocation(JsNameRef var1, JsExpression var2);

    private void addCapturedValueParameters(JsInvocation bind) {
        if (this.closureContext.getDescriptors().isEmpty()) {
            return;
        }
        List<JsExpression> expressions = this.getCapturedValueParametersList(bind);
        for (VariableDescriptor variableDescriptor : this.closureContext.getDescriptors()) {
            JsName name = this.context.getNameForDescriptor(variableDescriptor);
            this.fun.getParameters().add(new JsParameter(name));
            expressions.add(name.makeRef());
        }
    }

    protected List<JsExpression> getCapturedValueParametersList(JsInvocation invocation) {
        return invocation.getArguments();
    }
}

