/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.patterns;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.DescriptorPredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.NamePredicate;

public final class PatternBuilder {
    @NotNull
    private static final NamePredicate JET = new NamePredicate("jet");

    private PatternBuilder() {
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull NamePredicate checker, @NotNull String stringWithPattern) {
        ArrayList<NamePredicate> checkers = Lists.newArrayList(checker);
        checkers.addAll(PatternBuilder.parseStringAsCheckerList(stringWithPattern));
        return PatternBuilder.pattern(checkers);
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull String stringWithPattern, @NotNull NamePredicate checker) {
        ArrayList<NamePredicate> checkers = Lists.newArrayList(PatternBuilder.parseStringAsCheckerList(stringWithPattern));
        checkers.add(checker);
        return PatternBuilder.pattern(checkers);
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull String string) {
        List<NamePredicate> checkers = PatternBuilder.parseStringAsCheckerList(string);
        return PatternBuilder.pattern(checkers);
    }

    @NotNull
    private static List<NamePredicate> parseStringAsCheckerList(@NotNull String stringWithPattern) {
        String[] subPatterns = stringWithPattern.split("\\.");
        ArrayList<NamePredicate> checkers = Lists.newArrayList();
        for (String subPattern : subPatterns) {
            String[] validNames = subPattern.split("\\|");
            checkers.add(new NamePredicate(validNames));
        }
        return checkers;
    }

    @NotNull
    private static DescriptorPredicate pattern(@NotNull List<NamePredicate> checkers) {
        final ArrayList<NamePredicate> checkersWithPrefixChecker = Lists.newArrayList(JET);
        checkersWithPrefixChecker.addAll(checkers);
        return new DescriptorPredicate(){

            @Override
            public boolean apply(@Nullable FunctionDescriptor descriptor) {
                assert (descriptor != null);
                try {
                    return this.doApply(descriptor);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }

            private boolean doApply(@NotNull FunctionDescriptor descriptor) {
                List<Name> nameParts = DescriptorUtils.getFQName(descriptor).pathSegments();
                if (nameParts.size() != checkersWithPrefixChecker.size()) {
                    return false;
                }
                return this.allNamePartsValid(nameParts);
            }

            private boolean allNamePartsValid(@NotNull List<Name> nameParts) {
                for (int i = 0; i < nameParts.size(); ++i) {
                    Name namePart = nameParts.get(i);
                    NamePredicate correspondingPredicate = (NamePredicate)checkersWithPrefixChecker.get(i);
                    if (correspondingPredicate.apply(namePart)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @NotNull
    public static DescriptorPredicate pattern(NamePredicate ... checkers) {
        return PatternBuilder.pattern(Arrays.asList(checkers));
    }
}

