/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.AccessTranslator;
import org.jetbrains.k2js.translate.reference.ArrayAccessTranslator;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.reference.QualifiedExpressionTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;

public final class AccessTranslationUtils {
    private AccessTranslationUtils() {
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull JetExpression referenceExpression, @NotNull TranslationContext context) {
        assert (referenceExpression instanceof JetReferenceExpression || referenceExpression instanceof JetQualifiedExpression);
        if (referenceExpression instanceof JetQualifiedExpression) {
            return QualifiedExpressionTranslator.getAccessTranslator((JetQualifiedExpression)referenceExpression, context);
        }
        if (referenceExpression instanceof JetSimpleNameExpression) {
            return ReferenceTranslator.getAccessTranslator((JetSimpleNameExpression)referenceExpression, context);
        }
        assert (referenceExpression instanceof JetArrayAccessExpression);
        return ArrayAccessTranslator.newInstance((JetArrayAccessExpression)referenceExpression, context);
    }

    @NotNull
    public static CachedAccessTranslator getCachedAccessTranslator(@NotNull JetExpression referenceExpression, @NotNull TranslationContext context) {
        return AccessTranslationUtils.getAccessTranslator(referenceExpression, context).getCached();
    }

    @NotNull
    public static JsExpression translateAsGet(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        return AccessTranslationUtils.getAccessTranslator(expression, context).translateAsGet();
    }
}

