/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.reference.PropertyAccessTranslator;

public final class CachedPropertyAccessTranslator
implements CachedAccessTranslator {
    @NotNull
    private final PropertyAccessTranslator baseTranslator;
    @Nullable
    private final TemporaryVariable cachedReceiver;

    CachedPropertyAccessTranslator(@Nullable JsExpression receiverExpression, @NotNull PropertyAccessTranslator baseTranslator, @NotNull TranslationContext context) {
        this.cachedReceiver = receiverExpression != null ? context.declareTemporary(receiverExpression) : null;
        this.baseTranslator = baseTranslator;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        return this.baseTranslator.translateAsGet(this.receiverOrNull());
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression toSetTo) {
        return this.baseTranslator.translateAsSet(this.receiverOrNull(), toSetTo);
    }

    @Nullable
    private JsNameRef receiverOrNull() {
        return this.cachedReceiver != null ? this.cachedReceiver.reference() : null;
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        return this;
    }

    @Override
    @NotNull
    public List<TemporaryVariable> declaredTemporaries() {
        return this.cachedReceiver != null ? Collections.singletonList(this.cachedReceiver) : Collections.emptyList();
    }
}

