/*
 * Copyright 2010-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.jet.di;

import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.ClassBuilderFactory;
import com.intellij.openapi.project.Project;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethods;
import org.jetbrains.jet.codegen.ClassFileFactory;
import org.jetbrains.annotations.NotNull;
import javax.annotation.PreDestroy;

/* This file is generated by org.jetbrains.jet.generators.injectors.GenerateInjectors. DO NOT EDIT! */
public class InjectorForJvmCodegen {
    
    private final JetTypeMapper jetTypeMapper;
    private final GenerationState generationState;
    private final ClassBuilderFactory classBuilderFactory;
    private final Project project;
    private final BindingTrace bindingTrace;
    private final BindingContext bindingContext;
    private final ClassBuilderMode classBuilderMode;
    private final IntrinsicMethods intrinsics;
    private final ClassFileFactory classFileFactory;
    
    public InjectorForJvmCodegen(
        @NotNull JetTypeMapper jetTypeMapper,
        @NotNull GenerationState generationState,
        @NotNull ClassBuilderFactory classBuilderFactory,
        @NotNull Project project
    ) {
        this.jetTypeMapper = jetTypeMapper;
        this.generationState = generationState;
        this.classBuilderFactory = classBuilderFactory;
        this.project = project;
        this.bindingTrace = jetTypeMapper.getBindingTrace();
        this.bindingContext = bindingTrace.getBindingContext();
        this.classBuilderMode = classBuilderFactory.getClassBuilderMode();
        this.intrinsics = new IntrinsicMethods();
        this.classFileFactory = new ClassFileFactory(getGenerationState());

        this.classFileFactory.setBuilderFactory(classBuilderFactory);

        intrinsics.init();

    }
    
    @PreDestroy
    public void destroy() {
    }
    
    public JetTypeMapper getJetTypeMapper() {
        return this.jetTypeMapper;
    }
    
    public GenerationState getGenerationState() {
        return this.generationState;
    }
    
    public Project getProject() {
        return this.project;
    }
    
    public IntrinsicMethods getIntrinsics() {
        return this.intrinsics;
    }
    
    public ClassFileFactory getClassFileFactory() {
        return this.classFileFactory;
    }
    
}
