/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;

public class SubtypingConstraint
implements ConstraintFormula {
    private PsiType myS;
    private PsiType myT;
    private boolean myIsRefTypes;

    public SubtypingConstraint(PsiType t, PsiType s, boolean isRefTypes) {
        this.myT = t;
        this.myS = s;
        this.myIsRefTypes = isRefTypes;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        if (this.myIsRefTypes) {
            if (session.isProperType(this.myS) && session.isProperType(this.myT)) {
                if (this.myT == null || this.myS == null) {
                    return this.myS == this.myT;
                }
                return TypeConversionUtil.isAssignable(this.myT, this.myS);
            }
            InferenceVariable inferenceVariable = session.getInferenceVariable(this.myS);
            if (inferenceVariable != null) {
                inferenceVariable.addBound(this.myT, InferenceBound.UPPER);
                return true;
            }
            if (PsiType.NULL.equals(this.myS)) {
                return true;
            }
            inferenceVariable = session.getInferenceVariable(this.myT, false);
            if (inferenceVariable != null) {
                inferenceVariable.addBound(this.myS, InferenceBound.LOWER);
                return true;
            }
            if (this.myT instanceof PsiArrayType) {
                if (!(this.myS instanceof PsiArrayType)) {
                    return false;
                }
                PsiType tComponentType = ((PsiArrayType)this.myT).getComponentType();
                PsiType sComponentType = ((PsiArrayType)this.myS).getComponentType();
                if (!(tComponentType instanceof PsiPrimitiveType) && !(sComponentType instanceof PsiPrimitiveType)) {
                    constraints.add(new SubtypingConstraint(tComponentType, sComponentType, true));
                    return true;
                }
                return sComponentType instanceof PsiPrimitiveType && sComponentType.equals(tComponentType);
            }
            if (this.myT instanceof PsiClassType) {
                PsiClassType.ClassResolveResult TResult = ((PsiClassType)this.myT).resolveGenerics();
                PsiClass CClass = TResult.getElement();
                if (CClass != null) {
                    PsiSubstitutor sSubstitutor;
                    if (CClass instanceof PsiTypeParameter) {
                        if (this.myS instanceof PsiIntersectionType) {
                            for (PsiType conjunct : ((PsiIntersectionType)this.myS).getConjuncts()) {
                                if (!this.myT.equals(conjunct)) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    if (!(this.myS instanceof PsiClassType)) {
                        return false;
                    }
                    PsiClassType.ClassResolveResult SResult = ((PsiClassType)this.myS).resolveGenerics();
                    PsiClass SClass = SResult.getElement();
                    PsiSubstitutor tSubstitutor = TResult.getSubstitutor();
                    PsiSubstitutor psiSubstitutor = sSubstitutor = SClass != null ? TypeConversionUtil.getClassSubstitutor(CClass, SClass, SResult.getSubstitutor()) : null;
                    if (sSubstitutor != null) {
                        for (PsiTypeParameter parameter : CClass.getTypeParameters()) {
                            PsiType tSubstituted = tSubstitutor.substitute(parameter);
                            PsiType sSubstituted = sSubstitutor.substituteWithBoundsPromotion(parameter);
                            constraints.add(new SubtypingConstraint(tSubstituted, sSubstituted, false));
                        }
                        return true;
                    }
                }
                return false;
            }
            if (this.myT instanceof PsiIntersectionType) {
                for (PsiType conjunct : ((PsiIntersectionType)this.myT).getConjuncts()) {
                    constraints.add(new SubtypingConstraint(conjunct, this.myS, true));
                }
                return true;
            }
            return !PsiType.NULL.equals(this.myT);
        }
        if (this.myT instanceof PsiWildcardType) {
            PsiType tBound = ((PsiWildcardType)this.myT).getBound();
            if (tBound == null) {
                return true;
            }
            if (((PsiWildcardType)this.myT).isExtends()) {
                if (tBound.equalsToText("java.lang.Object")) {
                    return true;
                }
                if (this.myS instanceof PsiWildcardType) {
                    PsiType sBound = ((PsiWildcardType)this.myS).getBound();
                    if (sBound != null && ((PsiWildcardType)this.myS).isExtends()) {
                        constraints.add(new SubtypingConstraint(tBound, sBound, true));
                        return true;
                    }
                } else {
                    constraints.add(new SubtypingConstraint(tBound, this.myS, true));
                    return true;
                }
                return false;
            }
            if (this.myS instanceof PsiCapturedWildcardType) {
                this.myS = ((PsiCapturedWildcardType)this.myS).getWildcard();
            }
            if (this.myS instanceof PsiWildcardType) {
                PsiType sBound = ((PsiWildcardType)this.myS).getBound();
                if (sBound != null && ((PsiWildcardType)this.myS).isSuper()) {
                    constraints.add(new SubtypingConstraint(sBound, tBound, true));
                    return true;
                }
            } else {
                constraints.add(new SubtypingConstraint(this.myS, tBound, true));
                return true;
            }
            return false;
        }
        InferenceVariable inferenceVariable = session.getInferenceVariable(this.myT);
        if (this.myS instanceof PsiWildcardType) {
            return inferenceVariable != null && inferenceVariable.isCaptured();
        }
        if (inferenceVariable != null) {
            inferenceVariable.addBound(this.myS, InferenceBound.EQ);
            return true;
        }
        inferenceVariable = session.getInferenceVariable(this.myS);
        if (inferenceVariable != null) {
            inferenceVariable.addBound(this.myT, InferenceBound.EQ);
            return true;
        }
        constraints.add(new SubtypingConstraint(this.myT, this.myS, true));
        return true;
    }

    @Override
    public void apply(PsiSubstitutor substitutor) {
        this.myT = substitutor.substitute(this.myT);
        this.myS = substitutor.substitute(this.myS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubtypingConstraint that = (SubtypingConstraint)o;
        if (this.myIsRefTypes != that.myIsRefTypes) {
            return false;
        }
        if (!this.myIsRefTypes && this.myS instanceof PsiCapturedWildcardType && this.myS != that.myS) {
            return false;
        }
        if (this.myS != null ? !this.myS.equals(that.myS) : that.myS != null) {
            return false;
        }
        return !(this.myT != null ? !this.myT.equals(that.myT) : that.myT != null);
    }

    public int hashCode() {
        int result = this.myS != null ? this.myS.hashCode() : 0;
        result = 31 * result + (this.myT != null ? this.myT.hashCode() : 0);
        result = 31 * result + (this.myIsRefTypes ? 1 : 0);
        return result;
    }
}

