/*
 * Decompiled with CFR 0.152.
 */
package kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jet.FloatIterator;
import jet.Function1;
import jet.Function2;
import jet.KotlinPackageFragment;
import jet.Unit;
import jet.runtime.ArrayIterator;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IndexIterator;
import kotlin.KotlinPackage$groupByTo$list$6;
import kotlin.KotlinPackage$sortBy$sortBy$6;
import kotlin.KotlinPackage-IterablesSpecial-4f1cf42e;
import kotlin.KotlinPackage-Maps-e4d92eef;
import kotlin.KotlinPackage-OrderingJVM-4763a71b;
import kotlin.Pair;

@KotlinPackageFragment(abiVersion=11)
public final class KotlinPackage-_FloatArrays-750d7c89 {
    public static final boolean all(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="predicate") Function1<? super Float, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            if (predicate.invoke(Float.valueOf(element)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static final boolean any(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="predicate") Function1<? super Float, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            if (!predicate.invoke(Float.valueOf(element)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static final int count(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="predicate") Function1<? super Float, ? extends Boolean> predicate) {
        int count = 0;
        for (int i = 0; i < $receiver.length; ++i) {
            Object object2;
            float element = $receiver[i];
            if (predicate.invoke(Float.valueOf(element)).booleanValue()) {
                object2 = count;
                ++count;
                continue;
            }
            object2 = Unit.VALUE;
        }
        return count;
    }

    public static final Float find(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="predicate") Function1<? super Float, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            if (!predicate.invoke(Float.valueOf(element)).booleanValue()) continue;
            return Float.valueOf(element);
        }
        return null;
    }

    public static final List<Float> filter(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="predicate") Function1<? super Float, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_FloatArrays-750d7c89.filterTo($receiver, (Collection)new ArrayList(), predicate);
    }

    public static final <C extends Collection<? super Float>> C filterTo(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="result") C result, @JetValueParameter(name="predicate") Function1<? super Float, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            Object object2 = predicate.invoke(Float.valueOf(element)) != false ? Boolean.valueOf(result.add((Float)Float.valueOf(element))) : Unit.VALUE;
        }
        return result;
    }

    public static final List<Float> filterNot(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="predicate") Function1<? super Float, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_FloatArrays-750d7c89.filterNotTo($receiver, (Collection)new ArrayList(), predicate);
    }

    public static final <C extends Collection<? super Float>> C filterNotTo(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="result") C result, @JetValueParameter(name="predicate") Function1<? super Float, ? extends Boolean> predicate) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            Object object2 = predicate.invoke(Float.valueOf(element)) == false ? Boolean.valueOf(result.add((Float)Float.valueOf(element))) : Unit.VALUE;
        }
        return result;
    }

    public static final Pair<List<? extends Float>, List<? extends Float>> partition(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="predicate") Function1<? super Float, ? extends Boolean> predicate) {
        ArrayList<Float> first = new ArrayList<Float>();
        ArrayList<Float> second = new ArrayList<Float>();
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            boolean bl = predicate.invoke(Float.valueOf(element)) != false ? first.add(Float.valueOf(element)) : second.add(Float.valueOf(element));
        }
        return new Pair<List<? extends Float>, List<? extends Float>>(first, second);
    }

    public static final <R> List<R> map(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="transform") Function1<? super Float, ? extends R> transform) {
        return (ArrayList)KotlinPackage-_FloatArrays-750d7c89.mapTo($receiver, (Collection)new ArrayList(), transform);
    }

    public static final <R, C extends Collection<? super R>> C mapTo(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="result") C result, @JetValueParameter(name="transform") Function1<? super Float, ? extends R> transform) {
        for (int i = 0; i < $receiver.length; ++i) {
            float item = $receiver[i];
            result.add(transform.invoke(Float.valueOf(item)));
        }
        return result;
    }

    public static final <R> List<R> flatMap(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="transform") Function1<? super Float, ? extends Iterable<? extends R>> transform) {
        return (ArrayList)KotlinPackage-_FloatArrays-750d7c89.flatMapTo($receiver, (Collection)new ArrayList(), transform);
    }

    public static final <R, C extends Collection<? super R>> C flatMapTo(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="result") C result, @JetValueParameter(name="transform") Function1<? super Float, ? extends Iterable<? extends R>> transform) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            Iterable<R> list2 = transform.invoke(Float.valueOf(element));
            for (R r : list2) {
                result.add(r);
            }
        }
        return result;
    }

    public static final void forEach(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="operation") Function1<? super Float, ? extends Unit> operation) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            operation.invoke(Float.valueOf(element));
        }
    }

    public static final <R> R fold(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="initial") R initial, @JetValueParameter(name="operation") Function2<? super R, ? super Float, ? extends R> operation) {
        R answer = initial;
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            answer = operation.invoke(answer, Float.valueOf(element));
        }
        return answer;
    }

    public static final <R> R foldRight(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="initial") R initial, @JetValueParameter(name="operation") Function2<? super Float, ? super R, ? extends R> operation) {
        R r = initial;
        int index = $receiver.length - 1;
        while (index >= 0) {
            r = operation.invoke(Float.valueOf($receiver[index--]), r);
        }
        return r;
    }

    public static final float reduce(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="operation") Function2<? super Float, ? super Float, ? extends Float> operation) {
        FloatIterator iterator2 = ArrayIterator.iterator($receiver);
        if (!iterator2.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        float result = iterator2.nextFloat();
        while (iterator2.hasNext()) {
            result = ((Number)operation.invoke(Float.valueOf(result), Float.valueOf(iterator2.nextFloat()))).floatValue();
        }
        return result;
    }

    public static final float reduceRight(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="operation") Function2<? super Float, ? super Float, ? extends Float> operation) {
        int index = $receiver.length - 1;
        if (index < 0) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        float r = $receiver[index--];
        while (index >= 0) {
            r = ((Number)operation.invoke(Float.valueOf($receiver[index--]), Float.valueOf(r))).floatValue();
        }
        return r;
    }

    public static final <K> Map<K, List<? extends Float>> groupBy(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="toKey") Function1<? super Float, ? extends K> toKey) {
        return KotlinPackage-_FloatArrays-750d7c89.groupByTo($receiver, new HashMap(), toKey);
    }

    public static final <K> Map<K, List<Float>> groupByTo(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="result") Map<K, List<Float>> result, @JetValueParameter(name="toKey") Function1<? super Float, ? extends K> toKey) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            K key = toKey.invoke(Float.valueOf(element));
            List<Float> list2 = KotlinPackage-Maps-e4d92eef.getOrPut(result, key, KotlinPackage$groupByTo$list$6.instance$);
            list2.add(Float.valueOf(element));
        }
        return result;
    }

    public static final List<Float> drop(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="n") int n) {
        return KotlinPackage-_FloatArrays-750d7c89.dropWhile($receiver, KotlinPackage-IterablesSpecial-4f1cf42e.countTo(n));
    }

    public static final List<Float> dropWhile(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="predicate") Function1<? super Float, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_FloatArrays-750d7c89.dropWhileTo($receiver, (List)new ArrayList(), predicate);
    }

    public static final <L extends List<? super Float>> L dropWhileTo(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="result") L result, @JetValueParameter(name="predicate") Function1<? super Float, ? extends Boolean> predicate) {
        int start = 1;
        for (int i = 0; i < $receiver.length; ++i) {
            Object object2;
            float element = $receiver[i];
            if (!(start != 0 ? predicate.invoke(Float.valueOf(element)) : false)) {
                start = 0;
                object2 = result.add((Float)Float.valueOf(element));
                continue;
            }
            object2 = Unit.VALUE;
        }
        return result;
    }

    public static final List<Float> take(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="n") int n) {
        return KotlinPackage-_FloatArrays-750d7c89.takeWhile($receiver, KotlinPackage-IterablesSpecial-4f1cf42e.countTo(n));
    }

    public static final List<Float> takeWhile(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="predicate") Function1<? super Float, ? extends Boolean> predicate) {
        return (ArrayList)KotlinPackage-_FloatArrays-750d7c89.takeWhileTo($receiver, (Collection)new ArrayList(), predicate);
    }

    public static final <C extends Collection<? super Float>> C takeWhileTo(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="result") C result, @JetValueParameter(name="predicate") Function1<? super Float, ? extends Boolean> predicate) {
        float element;
        for (int i = 0; i < $receiver.length && predicate.invoke(Float.valueOf(element = $receiver[i])).booleanValue(); ++i) {
            result.add((Float)Float.valueOf(element));
        }
        return result;
    }

    public static final <C extends Collection<? super Float>> C toCollection(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="result") C result) {
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            result.add((Float)Float.valueOf(element));
        }
        return result;
    }

    public static final List<Float> reverse(@JetValueParameter(name="$receiver") float[] $receiver) {
        ArrayList list2 = (ArrayList)KotlinPackage-_FloatArrays-750d7c89.toCollection($receiver, (Collection)new ArrayList());
        Collections.reverse(list2);
        return list2;
    }

    public static final LinkedList<Float> toLinkedList(@JetValueParameter(name="$receiver") float[] $receiver) {
        return (LinkedList)KotlinPackage-_FloatArrays-750d7c89.toCollection($receiver, (Collection)new LinkedList());
    }

    public static final List<Float> toList(@JetValueParameter(name="$receiver") float[] $receiver) {
        return (ArrayList)KotlinPackage-_FloatArrays-750d7c89.toCollection($receiver, (Collection)new ArrayList());
    }

    public static final Set<Float> toSet(@JetValueParameter(name="$receiver") float[] $receiver) {
        return (LinkedHashSet)KotlinPackage-_FloatArrays-750d7c89.toCollection($receiver, (Collection)new LinkedHashSet());
    }

    public static final SortedSet<Float> toSortedSet(@JetValueParameter(name="$receiver") float[] $receiver) {
        return (TreeSet)KotlinPackage-_FloatArrays-750d7c89.toCollection($receiver, (Collection)new TreeSet());
    }

    public static final List<Float> plus(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="element") float element) {
        ArrayList<Float> answer = new ArrayList<Float>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage-_FloatArrays-750d7c89.toCollection($receiver, (Collection)answer);
        answer.add(Float.valueOf(element));
        return answer;
    }

    public static final List<Float> plus(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="iterator") Iterator<? extends Float> iterator2) {
        ArrayList<Float> answer = new ArrayList<Float>();
        ArrayList cfr_ignored_0 = (ArrayList)KotlinPackage-_FloatArrays-750d7c89.toCollection($receiver, (Collection)answer);
        Iterator<? extends Float> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            float element = ((Number)iterator3.next()).floatValue();
            answer.add(Float.valueOf(element));
        }
        return answer;
    }

    public static final List<Float> plus(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="collection") Iterable<? extends Float> collection) {
        return KotlinPackage-_FloatArrays-750d7c89.plus($receiver, collection.iterator());
    }

    public static final Iterator<Pair<? extends Integer, ? extends Float>> withIndices(@JetValueParameter(name="$receiver") float[] $receiver) {
        return new IndexIterator(ArrayIterator.iterator($receiver));
    }

    public static final <R extends Comparable<? super R>> List<Float> sortBy(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="f") Function1<? super Float, ? extends R> f) {
        ArrayList sortedList = (ArrayList)KotlinPackage-_FloatArrays-750d7c89.toCollection($receiver, (Collection)new ArrayList());
        Comparator sortBy2 = KotlinPackage-OrderingJVM-4763a71b.comparator(new KotlinPackage$sortBy$sortBy$6(f));
        Collections.sort(sortedList, sortBy2);
        return sortedList;
    }

    public static final void appendString(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="buffer") Appendable buffer, @JetValueParameter(name="separator") String separator, @JetValueParameter(name="prefix") String prefix, @JetValueParameter(name="postfix") String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") String truncated) {
        buffer.append(prefix);
        int count = 0;
        for (int i = 0; i < $receiver.length; ++i) {
            float element = $receiver[i];
            if (++count > 1) {
                buffer.append(separator);
            }
            boolean bl = !(limit < 0) ? count <= limit : true;
            if (!bl) break;
            boolean bl2 = true;
            if (Float.valueOf(element) != null) {
                bl2 = false;
            }
            String text = bl2 ? "null" : String.valueOf(element);
            buffer.append(text);
        }
        boolean bl = limit >= 0 ? count > limit : false;
        if (bl) {
            buffer.append(truncated);
        }
        buffer.append(postfix);
    }

    public static /* synthetic */ void appendString$default(float[] fArray, Appendable appendable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 2) != 0) {
            string = ", ";
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            string4 = "...";
        }
        KotlinPackage-_FloatArrays-750d7c89.appendString(fArray, appendable, string, string2, string3, n, string4);
    }

    public static final String makeString(@JetValueParameter(name="$receiver") float[] $receiver, @JetValueParameter(name="separator") String separator, @JetValueParameter(name="prefix") String prefix, @JetValueParameter(name="postfix") String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") String truncated) {
        StringBuilder buffer = new StringBuilder();
        KotlinPackage-_FloatArrays-750d7c89.appendString($receiver, buffer, separator, prefix, postfix, limit, truncated);
        return buffer.toString();
    }

    public static /* synthetic */ String makeString$default(float[] fArray, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 1) != 0) {
            string = ", ";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "...";
        }
        return KotlinPackage-_FloatArrays-750d7c89.makeString(fArray, string, string2, string3, n, string4);
    }
}

