/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm;

import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.CLICompiler;
import org.jetbrains.jet.cli.common.CLIConfigurationKeys;
import org.jetbrains.jet.cli.common.ExitCode;
import org.jetbrains.jet.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.jet.cli.common.messages.MessageRenderer;
import org.jetbrains.jet.cli.common.messages.MessageUtil;
import org.jetbrains.jet.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.jet.cli.jvm.compiler.CommandLineScriptUtils;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.jet.cli.jvm.compiler.ModuleChunk;
import org.jetbrains.jet.cli.jvm.repl.ReplFromTerminal;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.config.CommonConfigurationKeys;
import org.jetbrains.jet.config.CompilerConfiguration;
import org.jetbrains.jet.utils.KotlinPaths;
import org.jetbrains.jet.utils.KotlinPathsFromHomeDir;
import org.jetbrains.jet.utils.PathUtil;

public class K2JVMCompiler
extends CLICompiler<K2JVMCompilerArguments> {
    public static void main(String ... args) {
        K2JVMCompiler.doMain(new K2JVMCompiler(), args);
    }

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JVMCompilerArguments arguments, @NotNull MessageCollector messageCollector, @NotNull Disposable rootDisposable) {
        ExitCode exitCode;
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
        }
        if (rootDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDisposable", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
        }
        KotlinPaths paths = arguments.kotlinHome != null ? new KotlinPathsFromHomeDir(new File(arguments.kotlinHome)) : PathUtil.getKotlinPathsForCompiler();
        messageCollector.report(CompilerMessageSeverity.LOGGING, "Using Kotlin home directory " + paths.getHomePath(), CompilerMessageLocation.NO_LOCATION);
        CompilerConfiguration configuration = new CompilerConfiguration();
        try {
            configuration.addAll(JVMConfigurationKeys.CLASSPATH_KEY, K2JVMCompiler.getClasspath(paths, arguments));
            configuration.addAll(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY, K2JVMCompiler.getAnnotationsPath(paths, arguments));
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageCollector, t);
            ExitCode exitCode2 = ExitCode.INTERNAL_ERROR;
            if (exitCode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
            }
            return exitCode2;
        }
        if (!arguments.script && arguments.module == null && arguments.src == null && arguments.freeArgs.isEmpty()) {
            ReplFromTerminal.run(rootDisposable, configuration);
            ExitCode exitCode3 = ExitCode.OK;
            if (exitCode3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
            }
            return exitCode3;
        }
        if (arguments.module == null) {
            if (arguments.script) {
                configuration.add(CommonConfigurationKeys.SOURCE_ROOTS_KEY, arguments.freeArgs.get(0));
            } else {
                if (arguments.src != null) {
                    List<String> sourcePathsSplitByPathSeparator = Arrays.asList(arguments.src.split(StringUtil.escapeToRegexp(File.pathSeparator)));
                    configuration.addAll(CommonConfigurationKeys.SOURCE_ROOTS_KEY, sourcePathsSplitByPathSeparator);
                }
                for (String freeArg : arguments.freeArgs) {
                    configuration.add(CommonConfigurationKeys.SOURCE_ROOTS_KEY, freeArg);
                }
            }
        }
        configuration.put(JVMConfigurationKeys.SCRIPT_PARAMETERS, arguments.script ? CommandLineScriptUtils.scriptParameters() : Collections.emptyList());
        configuration.put(JVMConfigurationKeys.GENERATE_NOT_NULL_ASSERTIONS, arguments.notNullAssertions);
        configuration.put(JVMConfigurationKeys.GENERATE_NOT_NULL_PARAMETER_ASSERTIONS, arguments.notNullParamAssertions);
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageCollector);
        messageCollector.report(CompilerMessageSeverity.LOGGING, "Configuring the compilation environment", CompilerMessageLocation.NO_LOCATION);
        try {
            File outputDir;
            this.configureEnvironment(configuration, arguments);
            File jar = arguments.jar != null ? new File(arguments.jar) : null;
            File file = outputDir = arguments.outputDir != null ? new File(arguments.outputDir) : null;
            if (arguments.module != null) {
                FilteringMessageCollector sanitizedCollector = new FilteringMessageCollector(messageCollector, Predicates.in(CompilerMessageSeverity.VERBOSE));
                ModuleChunk modules = CompileEnvironmentUtil.loadModuleDescriptions(paths, arguments.module, sanitizedCollector);
                if (outputDir != null) {
                    messageCollector.report(CompilerMessageSeverity.WARNING, "The '-output' option is ignored because '-module' is specified", CompilerMessageLocation.NO_LOCATION);
                }
                File directory = new File(arguments.module).getAbsoluteFile().getParentFile();
                KotlinToJVMBytecodeCompiler.compileModules(configuration, modules, directory, jar, arguments.includeRuntime);
            } else if (arguments.script) {
                List<String> scriptArgs = arguments.freeArgs.subList(1, arguments.freeArgs.size());
                JetCoreEnvironment environment = JetCoreEnvironment.createForProduction(rootDisposable, configuration);
                KotlinToJVMBytecodeCompiler.compileAndExecuteScript(paths, environment, scriptArgs);
            } else {
                JetCoreEnvironment environment = JetCoreEnvironment.createForProduction(rootDisposable, configuration);
                KotlinToJVMBytecodeCompiler.compileBunchOfSources(environment, jar, outputDir, arguments.includeRuntime);
            }
            exitCode = ExitCode.OK;
        }
        catch (CompilationException e) {
            messageCollector.report(CompilerMessageSeverity.EXCEPTION, MessageRenderer.PLAIN.renderException(e), MessageUtil.psiElementToMessageLocation(e.getElement()));
            ExitCode exitCode4 = ExitCode.INTERNAL_ERROR;
            if (exitCode4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
            }
            return exitCode4;
        }
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
        }
        return exitCode;
    }

    @Override
    @NotNull
    protected K2JVMCompilerArguments createArguments() {
        K2JVMCompilerArguments k2JVMCompilerArguments = new K2JVMCompilerArguments();
        if (k2JVMCompilerArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "createArguments"));
        }
        return k2JVMCompilerArguments;
    }

    @NotNull
    private static List<File> getClasspath(@NotNull KotlinPaths paths, @NotNull K2JVMCompilerArguments arguments) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "getClasspath"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "getClasspath"));
        }
        ArrayList<File> classpath = Lists.newArrayList();
        if (!arguments.noJdk) {
            classpath.add(PathUtil.findRtJar());
        }
        if (!arguments.noStdlib) {
            classpath.add(paths.getRuntimePath());
        }
        if (arguments.classpath != null) {
            for (String element : Splitter.on(File.pathSeparatorChar).split(arguments.classpath)) {
                classpath.add(new File(element));
            }
        }
        ArrayList<File> arrayList = classpath;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "getClasspath"));
        }
        return arrayList;
    }

    @NotNull
    private static List<File> getAnnotationsPath(@NotNull KotlinPaths paths, @NotNull K2JVMCompilerArguments arguments) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "getAnnotationsPath"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "getAnnotationsPath"));
        }
        ArrayList<File> annotationsPath = Lists.newArrayList();
        if (!arguments.noJdkAnnotations) {
            annotationsPath.add(paths.getJdkAnnotationsPath());
        }
        if (arguments.annotations != null) {
            for (String element : Splitter.on(File.pathSeparatorChar).split(arguments.annotations)) {
                annotationsPath.add(new File(element));
            }
        }
        ArrayList<File> arrayList = annotationsPath;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "getAnnotationsPath"));
        }
        return arrayList;
    }
}

