/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.Label;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.AnnotationCodegen;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.DefaultParameterValueLoader;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.JvmSerializationBindings;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.ParentCodegenAwareImpl;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.context.NamespaceFacadeContext;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterSignature;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.name.Name;

public class FunctionCodegen
extends ParentCodegenAwareImpl {
    private final CodegenContext owner;
    private final ClassBuilder v;

    public FunctionCodegen(@NotNull CodegenContext owner, @NotNull ClassBuilder v, @NotNull GenerationState state, MemberCodegen parentCodegen) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/codegen/FunctionCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/FunctionCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/FunctionCodegen", "<init>"));
        }
        super(state, parentCodegen);
        this.owner = owner;
        this.v = v;
    }

    public void gen(@NotNull JetNamedFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/codegen/FunctionCodegen", "gen"));
        }
        SimpleFunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, function);
        assert (functionDescriptor != null) : "No descriptor for function " + function.getText() + "\n" + "in " + function.getContainingFile().getVirtualFile();
        OwnerKind kind = this.owner.getContextKind();
        JvmMethodSignature method = this.typeMapper.mapSignature(functionDescriptor, true, kind);
        if (kind != OwnerKind.TRAIT_IMPL || function.getBodyExpression() != null) {
            this.generateMethod(function, method, functionDescriptor, new FunctionGenerationStrategy.FunctionDefault(this.state, functionDescriptor, function));
        }
        this.generateDefaultIfNeeded(this.owner.intoFunction(functionDescriptor), method, functionDescriptor, kind, DefaultParameterValueLoader.DEFAULT);
    }

    public void generateMethod(@Nullable PsiElement origin, @NotNull JvmMethodSignature jvmSignature, @NotNull FunctionDescriptor functionDescriptor, @NotNull FunctionGenerationStrategy strategy) {
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        this.generateMethod(origin, jvmSignature, functionDescriptor, this.owner.intoFunction(functionDescriptor), strategy);
    }

    public void generateMethod(@Nullable PsiElement origin, @NotNull JvmMethodSignature jvmSignature, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext methodContext, @NotNull FunctionGenerationStrategy strategy) {
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (methodContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContext", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        Method asmMethod = jvmSignature.getAsmMethod();
        MethodVisitor mv = this.v.newMethod(origin, AsmUtil.getMethodAsmFlags(functionDescriptor, methodContext.getContextKind()), asmMethod.getName(), asmMethod.getDescriptor(), jvmSignature.getGenericsSignature(), null);
        if (this.owner instanceof NamespaceFacadeContext) {
            Type ownerType = ((NamespaceFacadeContext)this.owner).getDelegateToClassType();
            this.v.getSerializationBindings().put(JvmSerializationBindings.IMPL_CLASS_NAME_FOR_CALLABLE, functionDescriptor, AsmUtil.shortNameByAsmType(ownerType));
        } else {
            this.v.getSerializationBindings().put(JvmSerializationBindings.METHOD_FOR_FUNCTION, functionDescriptor, asmMethod);
        }
        AnnotationCodegen.forMethod(mv, this.typeMapper).genAnnotations(functionDescriptor);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        this.generateParameterAnnotations(functionDescriptor, mv, jvmSignature);
        this.generateJetValueParameterAnnotations(mv, functionDescriptor, jvmSignature);
        if (AsmUtil.isAbstractMethod(functionDescriptor, methodContext.getContextKind())) {
            return;
        }
        this.generateMethodBody(mv, functionDescriptor, methodContext, jvmSignature, strategy);
        FunctionCodegen.endVisit(mv, null, origin);
        FunctionCodegen.generateBridgeIfNeeded(this.owner, this.state, this.v, jvmSignature.getAsmMethod(), functionDescriptor);
        methodContext.recordSyntheticAccessorIfNeeded(functionDescriptor, this.typeMapper);
    }

    private void generateParameterAnnotations(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        Iterator<ValueParameterDescriptor> iterator2 = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> kotlinParameterTypes = jvmSignature.getKotlinParameterTypes();
        for (int i = 0; i < kotlinParameterTypes.size(); ++i) {
            JvmMethodParameterKind kind = kotlinParameterTypes.get(i).getKind();
            if (kind == JvmMethodParameterKind.ENUM_NAME || kind == JvmMethodParameterKind.ENUM_ORDINAL) {
                FunctionCodegen.markEnumConstructorParameterAsSynthetic(mv, i);
                continue;
            }
            if (kind != JvmMethodParameterKind.VALUE) continue;
            ValueParameterDescriptor parameter = iterator2.next();
            this.v.getSerializationBindings().put(JvmSerializationBindings.INDEX_FOR_VALUE_PARAMETER, parameter, i);
            AnnotationCodegen.forParameter(i, mv, this.typeMapper).genAnnotations(parameter);
        }
    }

    private void generateJetValueParameterAnnotations(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull JvmMethodSignature jvmSignature) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateJetValueParameterAnnotations"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateJetValueParameterAnnotations"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateJetValueParameterAnnotations"));
        }
        Iterator<ValueParameterDescriptor> descriptors = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> kotlinParameterTypes = jvmSignature.getKotlinParameterTypes();
        for (int i = 0; i < kotlinParameterTypes.size(); ++i) {
            boolean nullableType;
            String name;
            JvmMethodParameterKind kind = kotlinParameterTypes.get(i).getKind();
            if (kind == JvmMethodParameterKind.ENUM_NAME || kind == JvmMethodParameterKind.ENUM_ORDINAL) {
                FunctionCodegen.markEnumConstructorParameterAsSynthetic(mv, i);
                continue;
            }
            if (kind == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor descriptor = descriptors.next();
                name = descriptor.getName().asString();
                nullableType = descriptor.getType().isNullable();
            } else {
                ReceiverParameterDescriptor receiver;
                String lowercaseKind = kind.name().toLowerCase();
                name = this.needIndexForVar(kind) ? "$" + lowercaseKind + "$" + i : "$" + lowercaseKind;
                nullableType = kind == JvmMethodParameterKind.RECEIVER ? (receiver = functionDescriptor.getReceiverParameter()) == null || receiver.getType().isNullable() : true;
            }
            AnnotationVisitor av = mv.visitParameterAnnotation(i, AsmUtil.asmDescByFqNameWithoutInnerClasses(DescriptorResolverUtils.fqNameByClass(JetValueParameter.class)), true);
            av.visit("name", name);
            if (nullableType) {
                av.visit("type", "?");
            }
            av.visitEnd();
        }
    }

    private static void markEnumConstructorParameterAsSynthetic(MethodVisitor mv, int i) {
        AnnotationVisitor av = mv.visitParameterAnnotation(i, "Ljava/lang/Synthetic;", true);
        av.visitEnd();
    }

    @Nullable
    private Type getThisTypeForFunction(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        ReceiverParameterDescriptor expectedThisObject = functionDescriptor.getExpectedThisObject();
        if (functionDescriptor instanceof ConstructorDescriptor) {
            return this.typeMapper.mapType(functionDescriptor.getReturnType());
        }
        if (expectedThisObject != null) {
            return this.typeMapper.mapType(expectedThisObject.getType());
        }
        if (DescriptorUtils.isFunctionLiteral(functionDescriptor) || CodegenBinding.isLocalNamedFun(functionDescriptor)) {
            return this.typeMapper.mapType(context.getThisDescriptor());
        }
        return null;
    }

    private void generateMethodBody(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context, @NotNull JvmMethodSignature signature, @NotNull FunctionGenerationStrategy strategy) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        HashSet<String> localVariableNames = new HashSet<String>(FunctionCodegen.getParameterNamesAsStrings(functionDescriptor));
        HashMap<Name, Label> labelsForSharedVars = new HashMap<Name, Label>();
        mv.visitCode();
        Label methodBegin = new Label();
        mv.visitLabel(methodBegin);
        if (context.getParentContext() instanceof NamespaceFacadeContext) {
            FunctionCodegen.generateStaticDelegateMethodBody(mv, signature.getAsmMethod(), (NamespaceFacadeContext)context.getParentContext());
        } else {
            FrameMap frameMap = strategy.getFrameMap(this.typeMapper, context);
            for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
                frameMap.enter(parameter, this.typeMapper.mapType(parameter));
            }
            labelsForSharedVars.putAll(this.createSharedVarsForParameters(mv, functionDescriptor, frameMap));
            if (!JetTypeMapper.isAccessor(functionDescriptor)) {
                AsmUtil.genNotNullAssertionsForParameters(new InstructionAdapter(mv), this.state, functionDescriptor, frameMap);
            }
            strategy.generateBody(mv, signature, context, this.getParentCodegen());
            localVariableNames.addAll(strategy.getLocalVariableNames());
        }
        Label methodEnd = new Label();
        mv.visitLabel(methodEnd);
        Type thisType = this.getThisTypeForFunction(functionDescriptor, context);
        this.generateLocalVariableTable(mv, signature, functionDescriptor, thisType, methodBegin, methodEnd, localVariableNames, labelsForSharedVars, context.getContextKind());
    }

    @NotNull
    private static List<String> getParameterNamesAsStrings(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "getParameterNamesAsStrings"));
        }
        List<ValueParameterDescriptor> parameters = functionDescriptor.getValueParameters();
        ArrayList<String> result = new ArrayList<String>(parameters.size());
        for (ValueParameterDescriptor parameter : parameters) {
            result.add(parameter.getName().asString());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionCodegen", "getParameterNamesAsStrings"));
        }
        return arrayList;
    }

    private void generateLocalVariableTable(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @NotNull FunctionDescriptor functionDescriptor, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, @NotNull Collection<String> localVariableNames, @NotNull Map<Name, Label> labelsForSharedVars, @NotNull OwnerKind ownerKind) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (jvmMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmMethodSignature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (methodBegin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodBegin", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (methodEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodEnd", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (localVariableNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localVariableNames", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (labelsForSharedVars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelsForSharedVars", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (ownerKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerKind", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        Iterator<ValueParameterDescriptor> valueParameters = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> params = jvmMethodSignature.getKotlinParameterTypes();
        int shift = 0;
        boolean isStatic = AsmUtil.isStaticMethod(ownerKind, functionDescriptor);
        if (!isStatic) {
            if (thisType != null) {
                mv.visitLocalVariable("this", thisType.getDescriptor(), null, methodBegin, methodEnd, shift);
            }
            ++shift;
        }
        for (int i = 0; i < params.size(); ++i) {
            JvmMethodParameterSignature param = params.get(i);
            JvmMethodParameterKind kind = param.getKind();
            String parameterName = "$" + param.getKind().name().toLowerCase();
            if (this.needIndexForVar(kind)) {
                parameterName = parameterName + "$" + i;
            }
            Type type = param.getAsmType();
            if (kind == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor parameter = valueParameters.next();
                Label divideLabel = labelsForSharedVars.get(parameter.getName());
                parameterName = parameter.getName().asString();
                if (divideLabel != null) {
                    mv.visitLocalVariable(parameterName, type.getDescriptor(), null, methodBegin, divideLabel, shift);
                    String nameForSharedVar = CodegenUtil.createTmpVariableName(localVariableNames);
                    localVariableNames.add(nameForSharedVar);
                    Type sharedVarType = this.typeMapper.getSharedVarType(parameter);
                    mv.visitLocalVariable(nameForSharedVar, sharedVarType.getDescriptor(), null, divideLabel, methodEnd, shift);
                    shift += Math.max(type.getSize(), sharedVarType.getSize());
                    continue;
                }
            }
            mv.visitLocalVariable(parameterName, type.getDescriptor(), null, methodBegin, methodEnd, shift);
            shift += type.getSize();
        }
    }

    @NotNull
    private Map<Name, Label> createSharedVarsForParameters(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull FrameMap frameMap) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "createSharedVarsForParameters"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "createSharedVarsForParameters"));
        }
        if (frameMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/jet/codegen/FunctionCodegen", "createSharedVarsForParameters"));
        }
        HashMap<Name, Label> labelsForSharedVars = new HashMap<Name, Label>();
        for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
            Type sharedVarType = this.typeMapper.getSharedVarType(parameter);
            if (sharedVarType == null) continue;
            Type localVarType = this.typeMapper.mapType(parameter);
            int index = frameMap.getIndex(parameter);
            mv.visitTypeInsn(187, sharedVarType.getInternalName());
            mv.visitInsn(89);
            mv.visitInsn(89);
            mv.visitMethodInsn(183, sharedVarType.getInternalName(), "<init>", "()V");
            mv.visitVarInsn(localVarType.getOpcode(21), index);
            mv.visitFieldInsn(181, sharedVarType.getInternalName(), "ref", StackValue.refType(localVarType).getDescriptor());
            Label labelForSharedVar = new Label();
            mv.visitLabel(labelForSharedVar);
            labelsForSharedVars.put(parameter.getName(), labelForSharedVar);
            mv.visitVarInsn(sharedVarType.getOpcode(54), index);
        }
        HashMap<Name, Label> hashMap = labelsForSharedVars;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionCodegen", "createSharedVarsForParameters"));
        }
        return hashMap;
    }

    private static void generateStaticDelegateMethodBody(@NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull NamespaceFacadeContext context) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateStaticDelegateMethodBody"));
        }
        if (asmMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmMethod", "org/jetbrains/jet/codegen/FunctionCodegen", "generateStaticDelegateMethodBody"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/FunctionCodegen", "generateStaticDelegateMethodBody"));
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        Type[] argTypes = asmMethod.getArgumentTypes();
        Label label = new Label();
        iv.visitLabel(label);
        iv.visitLineNumber(1, label);
        int k = 0;
        for (Type argType : argTypes) {
            iv.load(k, argType);
            k += argType.getSize();
        }
        iv.invokestatic(context.getDelegateToClassType().getInternalName(), asmMethod.getName(), asmMethod.getDescriptor());
        iv.areturn(asmMethod.getReturnType());
    }

    private boolean needIndexForVar(JvmMethodParameterKind kind) {
        return kind == JvmMethodParameterKind.SHARED_VAR || kind == JvmMethodParameterKind.SUPER_CALL_PARAM;
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description, @Nullable PsiElement method) {
        try {
            mv.visitMaxs(-1, -1);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CompilationException("wrong code generated" + (description != null ? " for " + description : "") + t.getClass().getName() + " " + t.getMessage(), t, method);
        }
        mv.visitEnd();
    }

    static void generateBridgeIfNeeded(CodegenContext owner, GenerationState state, ClassBuilder v, Method jvmSignature, FunctionDescriptor functionDescriptor) {
        if (owner.getContextKind() == OwnerKind.TRAIT_IMPL) {
            return;
        }
        Method method = state.getTypeMapper().mapSignature(functionDescriptor).getAsmMethod();
        LinkedList<FunctionDescriptor> bfsQueue = new LinkedList<FunctionDescriptor>();
        HashSet<FunctionDescriptor> visited = new HashSet<FunctionDescriptor>();
        bfsQueue.offer(functionDescriptor.getOriginal());
        visited.add(functionDescriptor.getOriginal());
        for (FunctionDescriptor functionDescriptor2 : functionDescriptor.getOverriddenDescriptors()) {
            FunctionDescriptor orig = functionDescriptor2.getOriginal();
            if (visited.contains(orig)) continue;
            bfsQueue.offer(functionDescriptor2);
            visited.add(functionDescriptor2);
        }
        HashSet<Method> bridgesToGenerate = new HashSet<Method>();
        while (!bfsQueue.isEmpty()) {
            FunctionDescriptor functionDescriptor3 = (FunctionDescriptor)bfsQueue.poll();
            if (functionDescriptor3.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
                Method overridden = state.getTypeMapper().mapSignature(functionDescriptor3.getOriginal()).getAsmMethod();
                if (!FunctionCodegen.differentMethods(method, overridden)) continue;
                bridgesToGenerate.add(overridden);
                continue;
            }
            for (FunctionDescriptor functionDescriptor4 : functionDescriptor3.getOverriddenDescriptors()) {
                FunctionDescriptor orig = functionDescriptor4.getOriginal();
                if (visited.contains(orig)) continue;
                bfsQueue.offer(orig);
                visited.add(orig);
            }
        }
        for (Method overridden : bridgesToGenerate) {
            FunctionCodegen.generateBridge(owner, state, v, jvmSignature, functionDescriptor, overridden);
        }
    }

    static void generateConstructorWithoutParametersIfNeeded(@NotNull GenerationState state, @NotNull CallableMethod method, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull ClassBuilder classBuilder) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (classBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classBuilder", "org/jetbrains/jet/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (!FunctionCodegen.isDefaultConstructorNeeded(state.getBindingContext(), constructorDescriptor)) {
            return;
        }
        int flags = AsmUtil.getVisibilityAccessFlag(constructorDescriptor);
        MethodVisitor mv = classBuilder.newMethod(null, flags, "<init>", "()V", null, null);
        if (state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        if (state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            InstructionAdapter v = new InstructionAdapter(mv);
            mv.visitCode();
            Type methodOwner = method.getOwner();
            Method jvmSignature = method.getSignature().getAsmMethod();
            v.load(0, methodOwner);
            int mask = 0;
            for (ValueParameterDescriptor parameterDescriptor : constructorDescriptor.getValueParameters()) {
                Type paramType = state.getTypeMapper().mapType(parameterDescriptor.getType());
                AsmUtil.pushDefaultValueOnStack(paramType, v);
                mask |= 1 << parameterDescriptor.getIndex();
            }
            v.iconst(mask);
            String desc = jvmSignature.getDescriptor().replace(")", "I)");
            v.invokespecial(methodOwner.getInternalName(), "<init>", desc);
            v.areturn(Type.VOID_TYPE);
            FunctionCodegen.endVisit(mv, "default constructor for " + methodOwner.getInternalName(), null);
        }
    }

    void generateDefaultIfNeeded(@NotNull MethodContext owner, @NotNull JvmMethodSignature signature, @NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind kind, @NotNull DefaultParameterValueLoader loadStrategy) {
        Type ownerType;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (loadStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadStrategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        DeclarationDescriptor contextClass = owner.getContextDescriptor().getContainingDeclaration();
        if (kind != OwnerKind.TRAIT_IMPL && contextClass instanceof ClassDescriptor && ((ClassDescriptor)contextClass).getKind() == ClassKind.TRAIT) {
            return;
        }
        if (!FunctionCodegen.isDefaultNeeded(functionDescriptor)) {
            return;
        }
        boolean isStatic = AsmUtil.isStatic(kind);
        Method jvmSignature = signature.getAsmMethod();
        int flags = 4097;
        if (contextClass instanceof NamespaceDescriptor) {
            ownerType = this.state.getTypeMapper().getOwner(functionDescriptor, kind, true);
        } else if (contextClass instanceof ClassDescriptor) {
            ownerType = this.state.getTypeMapper().mapClass((ClassDescriptor)contextClass);
        } else if (CodegenBinding.isLocalNamedFun(functionDescriptor)) {
            ownerType = CodegenBinding.asmTypeForAnonymousClass(this.state.getBindingContext(), functionDescriptor);
        } else {
            throw new IllegalStateException("Couldn't obtain owner name for " + functionDescriptor);
        }
        String descriptor = jvmSignature.getDescriptor().replace(")", "I)");
        boolean isConstructor = "<init>".equals(jvmSignature.getName());
        if (!isStatic && !isConstructor) {
            descriptor = descriptor.replace("(", "(" + ownerType.getDescriptor());
        }
        MethodVisitor mv = this.v.newMethod(null, flags | (isConstructor ? 0 : 8), isConstructor ? "<init>" : jvmSignature.getName() + "$default", descriptor, null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            this.generateDefaultImpl(owner, signature, functionDescriptor, isStatic, mv, loadStrategy);
        }
    }

    private void generateDefaultImpl(@NotNull MethodContext methodContext, @NotNull JvmMethodSignature signature, @NotNull FunctionDescriptor functionDescriptor, boolean aStatic, @NotNull MethodVisitor mv, @NotNull DefaultParameterValueLoader loadStrategy) {
        if (methodContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContext", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImpl"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImpl"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImpl"));
        }
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImpl"));
        }
        if (loadStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadStrategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImpl"));
        }
        mv.visitCode();
        FrameMap frameMap = new FrameMap();
        if (!aStatic) {
            frameMap.enterTemp(AsmTypeConstants.OBJECT_TYPE);
        }
        Method jvmSignature = signature.getAsmMethod();
        ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, jvmSignature.getReturnType(), methodContext, this.state, this.getParentCodegen());
        Type[] argTypes = jvmSignature.getArgumentTypes();
        List<ValueParameterDescriptor> paramDescrs = functionDescriptor.getValueParameters();
        Iterator<ValueParameterDescriptor> iterator2 = paramDescrs.iterator();
        int countOfExtraVarsInMethodArgs = 0;
        List<JvmMethodParameterSignature> params = signature.getKotlinParameterTypes();
        for (int i = 0; i < params.size(); ++i) {
            JvmMethodParameterSignature parameterSignature = params.get(i);
            if (parameterSignature.getKind() != JvmMethodParameterKind.VALUE) {
                ++countOfExtraVarsInMethodArgs;
                frameMap.enterTemp(parameterSignature.getAsmType());
                continue;
            }
            frameMap.enter(iterator2.next(), parameterSignature.getAsmType());
        }
        int maskIndex = frameMap.enterTemp(Type.INT_TYPE);
        InstructionAdapter iv = new InstructionAdapter(mv);
        FunctionCodegen.loadExplicitArgumentsOnStack(iv, AsmTypeConstants.OBJECT_TYPE, aStatic, signature);
        for (int index = 0; index < paramDescrs.size(); ++index) {
            ValueParameterDescriptor parameterDescriptor = paramDescrs.get(index);
            Type t = argTypes[countOfExtraVarsInMethodArgs + index];
            if (parameterDescriptor.declaresDefaultValue()) {
                iv.load(maskIndex, Type.INT_TYPE);
                iv.iconst(1 << index);
                iv.and(Type.INT_TYPE);
                Label loadArg = new Label();
                iv.ifeq(loadArg);
                loadStrategy.putValueOnStack(parameterDescriptor, codegen);
                int ind = frameMap.getIndex(parameterDescriptor);
                iv.store(ind, t);
                iv.mark(loadArg);
            }
            iv.load(frameMap.getIndex(parameterDescriptor), t);
        }
        CallableMethod method = null;
        method = functionDescriptor instanceof ConstructorDescriptor ? this.state.getTypeMapper().mapToCallableMethod((ConstructorDescriptor)functionDescriptor) : this.state.getTypeMapper().mapToCallableMethod(functionDescriptor, false, CodegenUtil.isCallInsideSameClassAsDeclared(functionDescriptor, methodContext), CodegenUtil.isCallInsideSameModuleAsDeclared(functionDescriptor, methodContext), OwnerKind.IMPLEMENTATION);
        iv.visitMethodInsn(method.getInvokeOpcode(), method.getOwner().getInternalName(), method.getSignature().getAsmMethod().getName(), method.getSignature().getAsmMethod().getDescriptor());
        iv.areturn(jvmSignature.getReturnType());
        FunctionCodegen.endVisit(mv, "default method", BindingContextUtils.callableDescriptorToDeclaration(this.state.getBindingContext(), functionDescriptor));
    }

    private static void loadExplicitArgumentsOnStack(@NotNull InstructionAdapter iv, @NotNull Type ownerType, boolean isStatic, @NotNull JvmMethodSignature signature) {
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/jet/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        if (ownerType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerType", "org/jetbrains/jet/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        int var = 0;
        if (!isStatic) {
            iv.load(var, ownerType);
            var += ownerType.getSize();
        }
        List<JvmMethodParameterSignature> params = signature.getKotlinParameterTypes();
        for (int i = 0; i < params.size(); ++i) {
            JvmMethodParameterSignature parameterSignature = params.get(i);
            if (parameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            Type type = parameterSignature.getAsmType();
            iv.load(var, type);
            var += type.getSize();
        }
    }

    private static boolean isDefaultNeeded(FunctionDescriptor functionDescriptor) {
        boolean needed = false;
        if (functionDescriptor != null) {
            for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
                if (!parameterDescriptor.declaresDefaultValue()) continue;
                needed = true;
                break;
            }
        }
        return needed;
    }

    private static boolean isDefaultConstructorNeeded(@NotNull BindingContext context, @NotNull ConstructorDescriptor constructorDescriptor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/FunctionCodegen", "isDefaultConstructorNeeded"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "isDefaultConstructorNeeded"));
        }
        ClassDescriptor classDescriptor = constructorDescriptor.getContainingDeclaration();
        if (CodegenBinding.canHaveOuter(context, classDescriptor)) {
            return false;
        }
        if (classDescriptor.getVisibility() == Visibilities.PRIVATE || constructorDescriptor.getVisibility() == Visibilities.PRIVATE) {
            return false;
        }
        if (constructorDescriptor.getValueParameters().isEmpty()) {
            return false;
        }
        for (ValueParameterDescriptor parameterDescriptor : constructorDescriptor.getValueParameters()) {
            if (parameterDescriptor.declaresDefaultValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean differentMethods(Method method, Method overridden) {
        Type[] overriddenArgumentTypes;
        if (!method.getReturnType().equals(overridden.getReturnType())) {
            return true;
        }
        Type[] methodArgumentTypes = method.getArgumentTypes();
        if (methodArgumentTypes.length != (overriddenArgumentTypes = overridden.getArgumentTypes()).length) {
            return true;
        }
        for (int i = 0; i != methodArgumentTypes.length; ++i) {
            if (methodArgumentTypes[i].equals(overriddenArgumentTypes[i])) continue;
            return true;
        }
        return false;
    }

    private static void generateBridge(CodegenContext owner, GenerationState state, ClassBuilder v, Method jvmSignature, FunctionDescriptor functionDescriptor, Method overridden) {
        int flags = 4161;
        MethodVisitor mv = v.newMethod(null, flags, jvmSignature.getName(), overridden.getDescriptor(), null, null);
        if (state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            Type[] argTypes = overridden.getArgumentTypes();
            Type[] originalArgTypes = jvmSignature.getArgumentTypes();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, AsmTypeConstants.OBJECT_TYPE);
            int reg = 1;
            for (int i = 0; i < argTypes.length; ++i) {
                StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
                reg += argTypes[i].getSize();
            }
            iv.invokevirtual(v.getThisName(), jvmSignature.getName(), jvmSignature.getDescriptor());
            StackValue.onStack(jvmSignature.getReturnType()).put(overridden.getReturnType(), iv);
            iv.areturn(overridden.getReturnType());
            FunctionCodegen.endVisit(mv, "bridge method", BindingContextUtils.callableDescriptorToDeclaration(state.getBindingContext(), functionDescriptor));
        }
    }

    public void genDelegate(FunctionDescriptor functionDescriptor, FunctionDescriptor overriddenDescriptor, StackValue field) {
        this.genDelegate(functionDescriptor, (ClassDescriptor)overriddenDescriptor.getContainingDeclaration(), field, this.typeMapper.mapSignature(functionDescriptor), this.typeMapper.mapSignature(overriddenDescriptor.getOriginal()));
    }

    public void genDelegate(FunctionDescriptor functionDescriptor, ClassDescriptor toClass, StackValue field, JvmMethodSignature jvmDelegateMethodSignature, JvmMethodSignature jvmOverriddenMethodSignature) {
        Method overriddenMethod = jvmOverriddenMethodSignature.getAsmMethod();
        Method delegateMethod = jvmDelegateMethodSignature.getAsmMethod();
        int flags = 4097;
        MethodVisitor mv = this.v.newMethod(null, flags, delegateMethod.getName(), delegateMethod.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            Type[] argTypes = delegateMethod.getArgumentTypes();
            Type[] originalArgTypes = overriddenMethod.getArgumentTypes();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, AsmTypeConstants.OBJECT_TYPE);
            field.put(field.type, iv);
            int reg = 1;
            for (int i = 0; i < argTypes.length; ++i) {
                StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
                reg += argTypes[i].getSize();
            }
            String internalName = this.typeMapper.mapType(toClass).getInternalName();
            if (toClass.getKind() == ClassKind.TRAIT) {
                iv.invokeinterface(internalName, overriddenMethod.getName(), overriddenMethod.getDescriptor());
            } else {
                iv.invokevirtual(internalName, overriddenMethod.getName(), overriddenMethod.getDescriptor());
            }
            StackValue.onStack(overriddenMethod.getReturnType()).put(delegateMethod.getReturnType(), iv);
            iv.areturn(delegateMethod.getReturnType());
            FunctionCodegen.endVisit(mv, "Delegate method " + functionDescriptor + " to " + jvmOverriddenMethodSignature, BindingContextUtils.descriptorToDeclaration(this.bindingContext, functionDescriptor.getContainingDeclaration()));
            FunctionCodegen.generateBridgeIfNeeded(this.owner, this.state, this.v, jvmDelegateMethodSignature.getAsmMethod(), functionDescriptor);
        }
    }
}

