/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.binding;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.Stack;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.FunctionTypesUtil;
import org.jetbrains.jet.codegen.SamCodegenUtil;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.binding.PsiCodegenPredictor;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetCallableReferenceExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.descriptor.ClassDescriptorFromJvmBytecode;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetTokens;

class CodegenAnnotatingVisitor
extends JetVisitorVoid {
    private static final TokenSet BINARY_OPERATIONS = TokenSet.orSet(JetTokens.AUGMENTED_ASSIGNMENTS, TokenSet.create(JetTokens.PLUS, JetTokens.MINUS, JetTokens.MUL, JetTokens.DIV, JetTokens.PERC, JetTokens.RANGE, JetTokens.LT, JetTokens.GT, JetTokens.LTEQ, JetTokens.GTEQ, JetTokens.IDENTIFIER));
    private final Map<String, Integer> anonymousSubclassesCount = new HashMap<String, Integer>();
    private final Stack<ClassDescriptor> classStack = new Stack();
    private final Stack<String> nameStack = new Stack();
    private final BindingTrace bindingTrace;
    private final BindingContext bindingContext;

    public CodegenAnnotatingVisitor(BindingTrace bindingTrace) {
        this.bindingTrace = bindingTrace;
        this.bindingContext = bindingTrace.getBindingContext();
    }

    @NotNull
    private ClassDescriptor recordClassForFunction(@NotNull FunctionDescriptor funDescriptor, @NotNull JetType superType) {
        if (funDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "funDescriptor", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClassForFunction"));
        }
        if (superType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superType", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClassForFunction"));
        }
        ClassDescriptorImpl classDescriptor = new ClassDescriptorImpl(funDescriptor.getContainingDeclaration(), Collections.<AnnotationDescriptor>emptyList(), Modality.FINAL, Name.special("<closure>"));
        classDescriptor.initialize(false, Collections.emptyList(), Collections.singleton(superType), JetScope.EMPTY, Collections.<ConstructorDescriptor>emptySet(), null, false);
        this.bindingTrace.record(CodegenBinding.CLASS_FOR_FUNCTION, funDescriptor, classDescriptor);
        ClassDescriptorImpl classDescriptorImpl = classDescriptor;
        if (classDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClassForFunction"));
        }
        return classDescriptorImpl;
    }

    private String inventAnonymousClassName(JetElement declaration) {
        String top = CodegenUtil.peekFromStack(this.nameStack);
        Integer cnt = this.anonymousSubclassesCount.get(top);
        if (cnt == null) {
            cnt = 0;
        }
        String name = top + "$" + (cnt + 1);
        ClassDescriptor descriptor = this.bindingContext.get(BindingContext.CLASS, declaration);
        if (!(descriptor != null || declaration instanceof JetFunctionLiteralExpression || declaration instanceof JetNamedFunction || declaration instanceof JetObjectLiteralExpression || declaration instanceof JetCallableReferenceExpression)) {
            throw new IllegalStateException("Class-less declaration which is not JetFunctionLiteralExpression|JetNamedFunction|JetObjectLiteralExpression|JetCallableReferenceExpression : " + declaration.getClass().getName());
        }
        this.anonymousSubclassesCount.put(top, cnt + 1);
        return name;
    }

    @Override
    public void visitJetElement(JetElement element) {
        super.visitJetElement(element);
        element.acceptChildren(this);
    }

    @Override
    public void visitJetFile(JetFile file) {
        if (file.isScript()) {
            ClassDescriptor classDescriptor = this.bindingContext.get(CodegenBinding.CLASS_FOR_SCRIPT, this.bindingContext.get(BindingContext.SCRIPT, file.getScript()));
            this.classStack.push(classDescriptor);
            this.nameStack.push(CodegenBinding.asmTypeForScriptPsi(this.bindingContext, file.getScript()).getInternalName());
        } else {
            this.nameStack.push(JvmClassName.byFqNameWithoutInnerClasses(JetPsiUtil.getFQName(file)).getInternalName());
        }
        file.acceptChildren(this);
        this.nameStack.pop();
        if (file.isScript()) {
            this.classStack.pop();
        }
    }

    @Override
    public void visitEnumEntry(JetEnumEntry enumEntry) {
        ClassDescriptor descriptor = this.bindingContext.get(BindingContext.CLASS, enumEntry);
        assert (descriptor != null);
        boolean trivial = enumEntry.getDeclarations().isEmpty();
        if (!trivial) {
            this.bindingTrace.record(CodegenBinding.ENUM_ENTRY_CLASS_NEED_SUBCLASS, descriptor);
            super.visitEnumEntry(enumEntry);
        } else {
            Type asmType = this.bindingTrace.get(CodegenBinding.ASM_TYPE, CodegenUtil.peekFromStack(this.classStack));
            assert (PsiCodegenPredictor.checkPredictedNameFromPsi(this.bindingTrace, descriptor, asmType));
            this.bindingTrace.record(CodegenBinding.ASM_TYPE, descriptor, asmType);
        }
    }

    @Override
    public void visitClassObject(JetClassObject classObject) {
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, classObject.getObjectDeclaration());
        assert (classDescriptor != null);
        String name = CodegenUtil.peekFromStack(this.nameStack) + "$object";
        this.recordClosure(classObject, classDescriptor, name, false);
        this.classStack.push(classDescriptor);
        this.nameStack.push(name);
        super.visitClassObject(classObject);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitObjectDeclaration(JetObjectDeclaration declaration) {
        if (declaration.getParent() instanceof JetObjectLiteralExpression || declaration.getParent() instanceof JetClassObject) {
            super.visitObjectDeclaration(declaration);
        } else {
            ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, declaration);
            if (classDescriptor == null) {
                return;
            }
            String name = this.getName(classDescriptor);
            this.recordClosure(declaration, classDescriptor, name, false);
            this.classStack.push(classDescriptor);
            this.nameStack.push(name);
            super.visitObjectDeclaration(declaration);
            this.nameStack.pop();
            this.classStack.pop();
        }
    }

    @Override
    public void visitClass(JetClass klass) {
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, klass);
        if (classDescriptor == null) {
            return;
        }
        String name = this.getName(classDescriptor);
        this.recordClosure(klass, classDescriptor, name, false);
        this.classStack.push(classDescriptor);
        this.nameStack.push(name);
        super.visitClass(klass);
        this.nameStack.pop();
        this.classStack.pop();
    }

    private String getName(ClassDescriptor classDescriptor) {
        String base = CodegenUtil.peekFromStack(this.nameStack);
        return DescriptorUtils.isTopLevelDeclaration(classDescriptor) ? (base.isEmpty() ? classDescriptor.getName().asString() : base + '/' + classDescriptor.getName()) : base + '$' + classDescriptor.getName();
    }

    @Override
    public void visitObjectLiteralExpression(JetObjectLiteralExpression expression) {
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, expression.getObjectDeclaration());
        if (classDescriptor == null) {
            super.visitObjectLiteralExpression(expression);
            return;
        }
        String name = this.inventAnonymousClassName(expression.getObjectDeclaration());
        this.recordClosure(expression.getObjectDeclaration(), classDescriptor, name, false);
        this.classStack.push(classDescriptor);
        this.nameStack.push(this.bindingContext.get(CodegenBinding.ASM_TYPE, classDescriptor).getInternalName());
        super.visitObjectLiteralExpression(expression);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitFunctionLiteralExpression(JetFunctionLiteralExpression expression) {
        JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionLiteral);
        if (functionDescriptor == null) {
            return;
        }
        String name = this.inventAnonymousClassName(expression);
        JetType superType = FunctionTypesUtil.getSuperTypeForClosure(functionDescriptor, false);
        ClassDescriptor classDescriptor = this.recordClassForFunction(functionDescriptor, superType);
        this.recordClosure(functionLiteral, classDescriptor, name, true);
        this.classStack.push(classDescriptor);
        this.nameStack.push(name);
        super.visitFunctionLiteralExpression(expression);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitCallableReferenceExpression(JetCallableReferenceExpression expression) {
        FunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, expression);
        if (functionDescriptor == null) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> referencedFunction = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getCallableReference());
        if (referencedFunction == null) {
            return;
        }
        JetType superType = FunctionTypesUtil.getSuperTypeForClosure((FunctionDescriptor)referencedFunction.getResultingDescriptor(), true);
        String name = this.inventAnonymousClassName(expression);
        ClassDescriptor classDescriptor = this.recordClassForFunction(functionDescriptor, superType);
        this.recordClosure(expression, classDescriptor, name, true);
        this.classStack.push(classDescriptor);
        this.nameStack.push(name);
        super.visitCallableReferenceExpression(expression);
        this.nameStack.pop();
        this.classStack.pop();
    }

    private void recordClosure(@NotNull JetElement element, @NotNull ClassDescriptor classDescriptor, @NotNull String name, boolean functionLiteral) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClosure"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClosure"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClosure"));
        }
        CodegenBinding.recordClosure(this.bindingTrace, element, classDescriptor, CodegenUtil.peekFromStack(this.classStack), Type.getObjectType(name), functionLiteral);
    }

    @Override
    public void visitProperty(JetProperty property2) {
        DeclarationDescriptor propertyDescriptor = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2);
        if (propertyDescriptor == null) {
            return;
        }
        String nameForClassOrNamespaceMember = this.getNameForClassOrNamespaceMember(propertyDescriptor);
        if (nameForClassOrNamespaceMember != null) {
            this.nameStack.push(nameForClassOrNamespaceMember);
        } else {
            this.nameStack.push(CodegenUtil.peekFromStack(this.nameStack) + '$' + property2.getName());
        }
        super.visitProperty(property2);
        this.nameStack.pop();
    }

    @Override
    public void visitNamedFunction(JetNamedFunction function) {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
        if (functionDescriptor == null) {
            return;
        }
        String nameForClassOrNamespaceMember = this.getNameForClassOrNamespaceMember(functionDescriptor);
        if (nameForClassOrNamespaceMember != null) {
            this.nameStack.push(nameForClassOrNamespaceMember);
            super.visitNamedFunction(function);
            this.nameStack.pop();
        } else {
            String name = this.inventAnonymousClassName(function);
            JetType superType = FunctionTypesUtil.getSuperTypeForClosure(functionDescriptor, false);
            ClassDescriptor classDescriptor = this.recordClassForFunction(functionDescriptor, superType);
            this.recordClosure(function, classDescriptor, name, true);
            this.classStack.push(classDescriptor);
            this.nameStack.push(name);
            super.visitNamedFunction(function);
            this.nameStack.pop();
            this.classStack.pop();
        }
    }

    @Nullable
    private String getNameForClassOrNamespaceMember(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "getNameForClassOrNamespaceMember"));
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        String peek = CodegenUtil.peekFromStack(this.nameStack);
        String name = descriptor.getName().asString();
        if (containingDeclaration instanceof ClassDescriptor) {
            return peek + '$' + name;
        }
        if (containingDeclaration instanceof NamespaceDescriptor) {
            FqName qualifiedName = ((NamespaceDescriptor)containingDeclaration).getFqName();
            String packageClassShortName = PackageClassUtils.getPackageClassName(qualifiedName);
            String packageClassName = peek.isEmpty() ? packageClassShortName : peek + "/" + packageClassShortName;
            return packageClassName + '$' + name;
        }
        return null;
    }

    @Override
    public void visitCallExpression(JetCallExpression expression) {
        super.visitCallExpression(expression);
        ResolvedCall<? extends CallableDescriptor> call = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getCalleeExpression());
        if (call == null) {
            return;
        }
        CallableDescriptor descriptor = call.getResultingDescriptor();
        if (!(descriptor instanceof FunctionDescriptor)) {
            return;
        }
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)descriptor);
        if (original == null) {
            return;
        }
        List<ResolvedValueArgument> valueArguments = call.getValueArgumentsByIndex();
        for (ValueParameterDescriptor valueParameter : original.getValueParameters()) {
            ClassDescriptorFromJvmBytecode samInterface = CodegenAnnotatingVisitor.getInterfaceIfSamType(valueParameter.getType());
            if (samInterface == null) continue;
            ResolvedValueArgument resolvedValueArgument = valueArguments.get(valueParameter.getIndex());
            assert (resolvedValueArgument instanceof ExpressionValueArgument) : resolvedValueArgument;
            ValueArgument valueArgument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument();
            assert (valueArgument != null);
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            assert (argumentExpression != null) : valueArgument.asElement().getText();
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, argumentExpression, samInterface);
        }
    }

    @Override
    public void visitBinaryExpression(JetBinaryExpression expression) {
        super.visitBinaryExpression(expression);
        FunctionDescriptor operationDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        if (operationDescriptor == null) {
            return;
        }
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter(operationDescriptor);
        if (original == null) {
            return;
        }
        ClassDescriptorFromJvmBytecode samInterfaceOfParameter = CodegenAnnotatingVisitor.getInterfaceIfSamType(original.getValueParameters().get(0).getType());
        if (samInterfaceOfParameter == null) {
            return;
        }
        IElementType token = expression.getOperationToken();
        if (BINARY_OPERATIONS.contains(token)) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression.getRight(), samInterfaceOfParameter);
        } else if (token == JetTokens.IN_KEYWORD || token == JetTokens.NOT_IN) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression.getLeft(), samInterfaceOfParameter);
        }
    }

    @Override
    public void visitArrayAccessExpression(JetArrayAccessExpression expression) {
        super.visitArrayAccessExpression(expression);
        FunctionDescriptor operationDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression);
        if (operationDescriptor == null) {
            return;
        }
        boolean isSetter = operationDescriptor.getName().asString().equals("set");
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter(operationDescriptor);
        if (original == null) {
            return;
        }
        List<JetExpression> indexExpressions = expression.getIndexExpressions();
        List<ValueParameterDescriptor> parameters = original.getValueParameters();
        for (ValueParameterDescriptor valueParameter : parameters) {
            ClassDescriptorFromJvmBytecode samInterface = CodegenAnnotatingVisitor.getInterfaceIfSamType(valueParameter.getType());
            if (samInterface == null) continue;
            if (isSetter && valueParameter.getIndex() == parameters.size() - 1) {
                PsiElement parent = expression.getParent();
                if (!(parent instanceof JetBinaryExpression) || ((JetBinaryExpression)parent).getOperationToken() != JetTokens.EQ) continue;
                JetExpression right = ((JetBinaryExpression)parent).getRight();
                this.bindingTrace.record(CodegenBinding.SAM_VALUE, right, samInterface);
                continue;
            }
            JetExpression indexExpression = indexExpressions.get(valueParameter.getIndex());
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, indexExpression, samInterface);
        }
    }

    @Nullable
    private static ClassDescriptorFromJvmBytecode getInterfaceIfSamType(@NotNull JetType originalType) {
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "getInterfaceIfSamType"));
        }
        if (!SingleAbstractMethodUtils.isSamType(originalType)) {
            return null;
        }
        ClassDescriptorFromJvmBytecode samInterface = (ClassDescriptorFromJvmBytecode)originalType.getConstructor().getDeclarationDescriptor();
        assert (samInterface != null);
        return samInterface;
    }
}

