/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class ClassId {
    private final FqName packageFqName;
    private final FqNameUnsafe relativeClassName;

    @NotNull
    public static ClassId fromFqNameAndContainingDeclaration(@NotNull FqNameUnsafe fqName, @NotNull ClassOrNamespaceDescriptor containingDeclaration) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/descriptors/serialization/ClassId", "fromFqNameAndContainingDeclaration"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/descriptors/serialization/ClassId", "fromFqNameAndContainingDeclaration"));
        }
        NamespaceDescriptor containingNamespace = DescriptorUtils.getParentOfType(containingDeclaration, NamespaceDescriptor.class, false);
        assert (containingNamespace != null);
        List<Name> fullNameSegments = fqName.pathSegments();
        FqName namespaceFqName = DescriptorUtils.getFQName(containingNamespace).toSafe();
        List<Name> namespaceNameSegments = namespaceFqName.pathSegments();
        assert (((Object)fullNameSegments.subList(0, namespaceNameSegments.size())).equals(namespaceNameSegments));
        List<Name> relativeNameSegments = fullNameSegments.subList(namespaceNameSegments.size(), fullNameSegments.size());
        ClassId classId = new ClassId(namespaceFqName, FqNameUnsafe.fromSegments(relativeNameSegments));
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/ClassId", "fromFqNameAndContainingDeclaration"));
        }
        return classId;
    }

    public ClassId(@NotNull FqName packageFqName, @NotNull FqNameUnsafe relativeClassName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/jet/descriptors/serialization/ClassId", "<init>"));
        }
        if (relativeClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeClassName", "org/jetbrains/jet/descriptors/serialization/ClassId", "<init>"));
        }
        this.packageFqName = packageFqName;
        assert (!relativeClassName.isRoot()) : "Class name must not be root. " + packageFqName;
        this.relativeClassName = relativeClassName;
    }

    @NotNull
    public FqName getPackageFqName() {
        FqName fqName = this.packageFqName;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/ClassId", "getPackageFqName"));
        }
        return fqName;
    }

    @NotNull
    public FqNameUnsafe getRelativeClassName() {
        FqNameUnsafe fqNameUnsafe = this.relativeClassName;
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/ClassId", "getRelativeClassName"));
        }
        return fqNameUnsafe;
    }

    @NotNull
    public ClassId createNestedClassId(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/ClassId", "createNestedClassId"));
        }
        ClassId classId = new ClassId(this.getPackageFqName(), this.relativeClassName.child(name));
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/ClassId", "createNestedClassId"));
        }
        return classId;
    }

    @NotNull
    public ClassId getOuterClassId() {
        ClassId classId = new ClassId(this.getPackageFqName(), this.relativeClassName.parent());
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/ClassId", "getOuterClassId"));
        }
        return classId;
    }

    public boolean isTopLevelClass() {
        return this.relativeClassName.parent().isRoot();
    }

    public FqNameUnsafe asSingleFqName() {
        if (this.packageFqName.isRoot()) {
            return this.relativeClassName;
        }
        return new FqNameUnsafe(this.packageFqName.asString() + "." + this.relativeClassName.asString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassId id = (ClassId)o;
        if (!this.packageFqName.equals(id.packageFqName)) {
            return false;
        }
        return this.relativeClassName.equals(id.relativeClassName);
    }

    public int hashCode() {
        int result = this.packageFqName.hashCode();
        result = 31 * result + this.relativeClassName.hashCode();
        return result;
    }

    public String toString() {
        if (this.packageFqName.isRoot()) {
            return "/" + this.relativeClassName;
        }
        return this.packageFqName.toString().replace('.', '/') + "/" + this.relativeClassName;
    }
}

