/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticHolder;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetTreeVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;

public class AnalyzingUtils {
    public static void checkForSyntacticErrors(@NotNull PsiElement root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jet/lang/resolve/AnalyzingUtils", "checkForSyntacticErrors"));
        }
        root.acceptChildren(new PsiErrorElementVisitor(){

            @Override
            public void visitErrorElement(PsiErrorElement element) {
                throw new IllegalArgumentException(element.getErrorDescription() + "; looking at " + element.getNode().getElementType() + " '" + element.getText() + DiagnosticUtils.atLocation(element));
            }
        });
    }

    public static List<PsiErrorElement> getSyntaxErrorRanges(@NotNull PsiElement root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jet/lang/resolve/AnalyzingUtils", "getSyntaxErrorRanges"));
        }
        final ArrayList<PsiErrorElement> r = new ArrayList<PsiErrorElement>();
        root.acceptChildren(new PsiErrorElementVisitor(){

            @Override
            public void visitErrorElement(PsiErrorElement element) {
                r.add(element);
            }
        });
        return r;
    }

    public static void throwExceptionOnErrors(BindingContext bindingContext) {
        for (Diagnostic diagnostic : bindingContext.getDiagnostics()) {
            DiagnosticHolder.THROW_EXCEPTION.report(diagnostic);
        }
    }

    public static String formDebugNameForBindingTrace(@NotNull String debugName, @Nullable Object resolutionSubjectForMessage) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/resolve/AnalyzingUtils", "formDebugNameForBindingTrace"));
        }
        if (resolutionSubjectForMessage instanceof PsiElement) {
            resolutionSubjectForMessage = ((PsiElement)resolutionSubjectForMessage).getText();
        }
        if (resolutionSubjectForMessage != null) {
            return debugName + " '" + resolutionSubjectForMessage + "'";
        }
        return debugName;
    }

    public static abstract class PsiErrorElementVisitor
    extends JetTreeVisitorVoid {
        @Override
        public abstract void visitErrorElement(PsiErrorElement var1);
    }
}

