/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;

public class FunctionAnalyzerExtension {
    @NotNull
    private BindingTrace trace;

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        if (bodiesResolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodiesResolveContext", "org/jetbrains/jet/lang/resolve/FunctionAnalyzerExtension", "process"));
        }
        for (Map.Entry<JetNamedFunction, SimpleFunctionDescriptor> entry : bodiesResolveContext.getFunctions().entrySet()) {
            JetNamedFunction function = entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = entry.getValue();
            List<AnalyzerExtension> extensions = this.getExtensions(functionDescriptor);
            for (AnalyzerExtension extension : extensions) {
                extension.process(functionDescriptor, function, this.trace);
            }
        }
    }

    @NotNull
    private List<AnalyzerExtension> getExtensions(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/FunctionAnalyzerExtension", "getExtensions"));
        }
        List<AnalyzerExtension> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/FunctionAnalyzerExtension", "getExtensions"));
        }
        return list2;
    }

    public static interface AnalyzerExtension {
        public void process(@NotNull FunctionDescriptor var1, @NotNull JetNamedFunction var2, @NotNull BindingTrace var3);
    }
}

