/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.results;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.types.JetType;

public class OverloadResolutionResultsUtil {
    @NotNull
    public static <D extends CallableDescriptor> OverloadResolutionResults<D> ambiguity(OverloadResolutionResults<D> results1, OverloadResolutionResults<D> results2) {
        ArrayList resultingCalls = Lists.newArrayList();
        resultingCalls.addAll(results1.getResultingCalls());
        resultingCalls.addAll(results2.getResultingCalls());
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.ambiguity(resultingCalls);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/OverloadResolutionResultsUtil", "ambiguity"));
        }
        return overloadResolutionResultsImpl;
    }

    @Nullable
    public static <D extends CallableDescriptor> JetType getResultingType(@NotNull OverloadResolutionResults<D> results, @NotNull ContextDependency contextDependency) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/results/OverloadResolutionResultsUtil", "getResultingType"));
        }
        if (contextDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDependency", "org/jetbrains/jet/lang/resolve/calls/results/OverloadResolutionResultsUtil", "getResultingType"));
        }
        ResolvedCallWithTrace<D> resultingCall = OverloadResolutionResultsUtil.getResultingCall((OverloadResolutionResultsImpl)results, contextDependency);
        return resultingCall != null ? resultingCall.getResultingDescriptor().getReturnType() : null;
    }

    @Nullable
    public static <D extends CallableDescriptor> ResolvedCallWithTrace<D> getResultingCall(@NotNull OverloadResolutionResultsImpl<D> results, @NotNull ContextDependency contextDependency) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/results/OverloadResolutionResultsUtil", "getResultingCall"));
        }
        if (contextDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDependency", "org/jetbrains/jet/lang/resolve/calls/results/OverloadResolutionResultsUtil", "getResultingCall"));
        }
        if (results.isSingleResult() && contextDependency == ContextDependency.INDEPENDENT && !CallResolverUtil.hasInferredReturnType(results.getResultingCall())) {
            return null;
        }
        return results.isSingleResult() ? results.getResultingCall() : null;
    }
}

