/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.descriptor;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassNonStaticMembersScope;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;

public class ClassDescriptorFromJvmBytecode
extends MutableClassDescriptorLite {
    private JetType functionTypeForSamInterface;
    private JavaClassNonStaticMembersScope scopeForConstructorResolve;
    private ConstructorDescriptor primaryConstructor;
    private Collection<ConstructorDescriptor> constructors;

    public ClassDescriptorFromJvmBytecode(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name, @NotNull ClassKind kind, boolean isInner) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/resolve/java/descriptor/ClassDescriptorFromJvmBytecode", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/descriptor/ClassDescriptorFromJvmBytecode", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/java/descriptor/ClassDescriptorFromJvmBytecode", "<init>"));
        }
        super(containingDeclaration, name, kind, isInner);
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        assert (this.scopeForConstructorResolve != null);
        if (this.constructors == null) {
            this.constructors = this.scopeForConstructorResolve.getConstructors();
        }
        Collection<ConstructorDescriptor> collection = this.constructors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/descriptor/ClassDescriptorFromJvmBytecode", "getConstructors"));
        }
        return collection;
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        if (this.primaryConstructor == null) {
            for (ConstructorDescriptor constructor : this.getConstructors()) {
                if (!constructor.isPrimary()) continue;
                if (this.primaryConstructor != null) {
                    throw new IllegalStateException("Class has more than one primary constructor: " + this.primaryConstructor + "\n" + constructor);
                }
                this.primaryConstructor = constructor;
            }
        }
        return this.primaryConstructor;
    }

    public void setScopeForConstructorResolve(@NotNull JavaClassNonStaticMembersScope scopeForConstructorResolve) {
        if (scopeForConstructorResolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForConstructorResolve", "org/jetbrains/jet/lang/resolve/java/descriptor/ClassDescriptorFromJvmBytecode", "setScopeForConstructorResolve"));
        }
        this.scopeForConstructorResolve = scopeForConstructorResolve;
    }

    @Nullable
    public JetType getFunctionTypeForSamInterface() {
        return this.functionTypeForSamInterface;
    }

    public void setFunctionTypeForSamInterface(@NotNull JetType functionTypeForSamInterface) {
        if (functionTypeForSamInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionTypeForSamInterface", "org/jetbrains/jet/lang/resolve/java/descriptor/ClassDescriptorFromJvmBytecode", "setFunctionTypeForSamInterface"));
        }
        this.functionTypeForSamInterface = functionTypeForSamInterface;
    }
}

