/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import java.util.List;
import jet.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.di.InjectorForLazyResolve;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorVisitorEmptyBodies;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.lazy.ForceResolveUtil;
import org.jetbrains.jet.lang.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.LazyResolveStorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class ResolveSession
implements KotlinCodeAnalyzer {
    public static final Function<FqName, Name> NO_ALIASES = new Function<FqName, Name>(){

        @Override
        public Name fun(FqName name) {
            return null;
        }
    };
    private final LazyResolveStorageManager storageManager;
    private final ModuleDescriptor module;
    private final LazyPackageDescriptor rootPackage;
    private final BindingTrace trace;
    private final DeclarationProviderFactory declarationProviderFactory;
    private final Predicate<FqNameUnsafe> specialClasses;
    private final InjectorForLazyResolve injector;
    private final Function<FqName, Name> classifierAliases;

    public ResolveSession(@NotNull Project project, @NotNull LazyResolveStorageManager storageManager, @NotNull ModuleDescriptorImpl rootDescriptor, @NotNull DeclarationProviderFactory declarationProviderFactory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (rootDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDescriptor", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (declarationProviderFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProviderFactory", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        this(project, storageManager, rootDescriptor, declarationProviderFactory, NO_ALIASES, Predicates.alwaysFalse(), new BindingTraceContext());
    }

    public ResolveSession(@NotNull Project project, @NotNull LazyResolveStorageManager storageManager, @NotNull ModuleDescriptorImpl rootDescriptor, @NotNull DeclarationProviderFactory declarationProviderFactory, @NotNull BindingTrace delegationTrace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (rootDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDescriptor", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (declarationProviderFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProviderFactory", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (delegationTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegationTrace", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        this(project, storageManager, rootDescriptor, declarationProviderFactory, NO_ALIASES, Predicates.alwaysFalse(), delegationTrace);
    }

    @Deprecated
    public ResolveSession(@NotNull Project project, @NotNull LazyResolveStorageManager storageManager, @NotNull ModuleDescriptorImpl rootDescriptor, @NotNull DeclarationProviderFactory declarationProviderFactory, @NotNull Function<FqName, Name> classifierAliases, @NotNull Predicate<FqNameUnsafe> specialClasses, @NotNull BindingTrace delegationTrace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (rootDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDescriptor", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (declarationProviderFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProviderFactory", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (classifierAliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifierAliases", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (specialClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specialClasses", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        if (delegationTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegationTrace", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "<init>"));
        }
        this.storageManager = storageManager;
        this.classifierAliases = classifierAliases;
        this.specialClasses = specialClasses;
        this.trace = storageManager.createSafeTrace(delegationTrace);
        this.injector = new InjectorForLazyResolve(project, this, rootDescriptor);
        this.module = rootDescriptor;
        PackageMemberDeclarationProvider provider = declarationProviderFactory.getPackageMemberDeclarationProvider(FqName.ROOT);
        assert (provider != null) : "No declaration provider for root package in " + rootDescriptor;
        this.rootPackage = new LazyPackageDescriptor(rootDescriptor, FqNameUnsafe.ROOT_NAME, this, provider);
        rootDescriptor.setRootNamespace(this.rootPackage);
        this.declarationProviderFactory = declarationProviderFactory;
    }

    @NotNull
    public InjectorForLazyResolve getInjector() {
        InjectorForLazyResolve injectorForLazyResolve = this.injector;
        if (injectorForLazyResolve == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getInjector"));
        }
        return injectorForLazyResolve;
    }

    public boolean isClassSpecial(@NotNull FqNameUnsafe fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "isClassSpecial"));
        }
        return this.specialClasses.apply(fqName);
    }

    @Override
    public ModuleDescriptor getRootModuleDescriptor() {
        return this.module;
    }

    @NotNull
    public LazyResolveStorageManager getStorageManager() {
        LazyResolveStorageManager lazyResolveStorageManager = this.storageManager;
        if (lazyResolveStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getStorageManager"));
        }
        return lazyResolveStorageManager;
    }

    @Override
    @Nullable
    public NamespaceDescriptor getPackageDescriptor(@NotNull Name shortName) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getPackageDescriptor"));
        }
        return this.rootPackage.getMemberScope().getNamespace(shortName);
    }

    @Override
    @Nullable
    public NamespaceDescriptor getPackageDescriptorByFqName(FqName fqName) {
        if (fqName.isRoot()) {
            return this.rootPackage;
        }
        List<Name> names = fqName.pathSegments();
        NamespaceDescriptor current = this.getPackageDescriptor(names.get(0));
        if (current == null) {
            return null;
        }
        for (Name name : names.subList(1, names.size())) {
            if ((current = current.getMemberScope().getNamespace(name)) != null) continue;
            return null;
        }
        return current;
    }

    @Override
    @NotNull
    public ClassDescriptor getClassDescriptor(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassDescriptor"));
        }
        if (classOrObject.getParent() instanceof JetClassObject) {
            LazyClassDescriptor lazyClassDescriptor = this.getClassObjectDescriptor((JetClassObject)classOrObject.getParent());
            if (lazyClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassDescriptor"));
            }
            return lazyClassDescriptor;
        }
        JetScope resolutionScope = this.getInjector().getScopeProvider().getResolutionScopeForDeclaration(classOrObject);
        Name name = ResolveSessionUtils.safeNameForLazyResolve(classOrObject.getNameAsName());
        resolutionScope.getClassifier(name);
        DeclarationDescriptor declaration = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, classOrObject);
        if (declaration == null) {
            resolutionScope.getObjectDescriptor(name);
            declaration = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, classOrObject);
        }
        if (declaration == null) {
            throw new IllegalArgumentException("Could not find a classifier for " + classOrObject + " " + classOrObject.getText());
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declaration;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getClassDescriptor"));
        }
        return classDescriptor;
    }

    LazyClassDescriptor getClassObjectDescriptor(JetClassObject classObject) {
        JetClassLikeInfo classObjectInfo;
        LazyClassDescriptor parentClassDescriptor;
        JetClass aClass = PsiTreeUtil.getParentOfType((PsiElement)classObject, JetClass.class);
        if (aClass != null) {
            parentClassDescriptor = (LazyClassDescriptor)this.getClassDescriptor(aClass);
        } else {
            JetObjectDeclaration objectDeclaration = PsiTreeUtil.getParentOfType((PsiElement)classObject, JetObjectDeclaration.class);
            assert (objectDeclaration != null) : String.format("Class object %s can be in class or object in file %s", classObject, classObject.getContainingFile().getText());
            parentClassDescriptor = (LazyClassDescriptor)this.getClassDescriptor(objectDeclaration);
        }
        parentClassDescriptor.getClassObjectDescriptor();
        DeclarationDescriptor declaration = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, classObject.getObjectDeclaration());
        if (declaration == null && (classObjectInfo = parentClassDescriptor.getClassObjectInfo(classObject)) != null) {
            final Name name = DescriptorUtils.getClassObjectName(parentClassDescriptor.getName());
            return this.storageManager.compute(new Function0<LazyClassDescriptor>(){

                @Override
                public LazyClassDescriptor invoke() {
                    return new LazyClassDescriptor(ResolveSession.this, parentClassDescriptor, name, classObjectInfo);
                }
            });
        }
        return (LazyClassDescriptor)declaration;
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.trace.getBindingContext();
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getBindingContext"));
        }
        return bindingContext;
    }

    @NotNull
    public BindingTrace getTrace() {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getTrace"));
        }
        return bindingTrace;
    }

    @NotNull
    public DeclarationProviderFactory getDeclarationProviderFactory() {
        DeclarationProviderFactory declarationProviderFactory = this.declarationProviderFactory;
        if (declarationProviderFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "getDeclarationProviderFactory"));
        }
        return declarationProviderFactory;
    }

    @Override
    @NotNull
    public DeclarationDescriptor resolveToDescriptor(JetDeclaration declaration) {
        DeclarationDescriptor result = declaration.accept(new JetVisitor<DeclarationDescriptor, Void>(){

            @Override
            public DeclarationDescriptor visitClass(@NotNull JetClass klass, Void data2) {
                if (klass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$3", "visitClass"));
                }
                return ResolveSession.this.getClassDescriptor(klass);
            }

            @Override
            public DeclarationDescriptor visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, Void data2) {
                if (declaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$3", "visitObjectDeclaration"));
                }
                PsiElement parent = declaration.getParent();
                if (parent instanceof JetClassObject) {
                    JetClassObject jetClassObject = (JetClassObject)parent;
                    return ResolveSession.this.resolveToDescriptor(jetClassObject);
                }
                return ResolveSession.this.getClassDescriptor(declaration);
            }

            @Override
            public DeclarationDescriptor visitClassObject(@NotNull JetClassObject classObject, Void data2) {
                if (classObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$3", "visitClassObject"));
                }
                return ResolveSession.this.getClassObjectDescriptor(classObject);
            }

            @Override
            public DeclarationDescriptor visitTypeParameter(@NotNull JetTypeParameter parameter, Void data2) {
                List<TypeParameterDescriptor> typeParameters;
                if (parameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$3", "visitTypeParameter"));
                }
                JetTypeParameterListOwner ownerElement = PsiTreeUtil.getParentOfType((PsiElement)parameter, JetTypeParameterListOwner.class);
                DeclarationDescriptor ownerDescriptor = ResolveSession.this.resolveToDescriptor(ownerElement);
                if (ownerDescriptor instanceof CallableDescriptor) {
                    CallableDescriptor callableDescriptor = (CallableDescriptor)ownerDescriptor;
                    typeParameters = callableDescriptor.getTypeParameters();
                } else if (ownerDescriptor instanceof ClassDescriptor) {
                    ClassDescriptor classDescriptor = (ClassDescriptor)ownerDescriptor;
                    typeParameters = classDescriptor.getTypeConstructor().getParameters();
                } else {
                    throw new IllegalStateException("Unknown owner kind for a type parameter: " + ownerDescriptor);
                }
                Name name = ResolveSessionUtils.safeNameForLazyResolve(parameter.getNameAsName());
                for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
                    if (!typeParameterDescriptor.getName().equals(name)) continue;
                    return typeParameterDescriptor;
                }
                throw new IllegalStateException("Type parameter " + name + " not found for " + ownerDescriptor);
            }

            @Override
            public DeclarationDescriptor visitNamedFunction(@NotNull JetNamedFunction function, Void data2) {
                if (function == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$3", "visitNamedFunction"));
                }
                JetScope scopeForDeclaration = ResolveSession.this.getInjector().getScopeProvider().getResolutionScopeForDeclaration(function);
                scopeForDeclaration.getFunctions(ResolveSessionUtils.safeNameForLazyResolve(function));
                return ResolveSession.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
            }

            @Override
            public DeclarationDescriptor visitParameter(@NotNull JetParameter parameter, Void data2) {
                if (parameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$3", "visitParameter"));
                }
                PsiElement grandFather = parameter.getParent().getParent();
                if (grandFather instanceof JetClass) {
                    JetClass jetClass = (JetClass)grandFather;
                    ClassDescriptor classDescriptor = ResolveSession.this.getClassDescriptor(jetClass);
                    if (parameter.getValOrVarNode() != null) {
                        classDescriptor.getDefaultType().getMemberScope().getProperties(ResolveSessionUtils.safeNameForLazyResolve(parameter));
                        return ResolveSession.this.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
                    }
                    ConstructorDescriptor constructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
                    assert (constructor != null) : "There are constructor parameters found, so a constructor should also exist";
                    constructor.getValueParameters();
                    return ResolveSession.this.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
                }
                return (DeclarationDescriptor)super.visitParameter(parameter, data2);
            }

            @Override
            public DeclarationDescriptor visitProperty(@NotNull JetProperty property2, Void data2) {
                if (property2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$3", "visitProperty"));
                }
                JetScope scopeForDeclaration = ResolveSession.this.getInjector().getScopeProvider().getResolutionScopeForDeclaration(property2);
                scopeForDeclaration.getProperties(ResolveSessionUtils.safeNameForLazyResolve(property2));
                return ResolveSession.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2);
            }

            @Override
            public DeclarationDescriptor visitObjectDeclarationName(@NotNull JetObjectDeclarationName declarationName, Void data2) {
                if (declarationName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationName", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$3", "visitObjectDeclarationName"));
                }
                JetScope scopeForDeclaration = ResolveSession.this.getInjector().getScopeProvider().getResolutionScopeForDeclaration(declarationName.getParent());
                scopeForDeclaration.getProperties(ResolveSessionUtils.safeNameForLazyResolve(declarationName));
                return ResolveSession.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, declarationName);
            }

            @Override
            public DeclarationDescriptor visitJetElement(@NotNull JetElement element, Void data2) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession$3", "visitJetElement"));
                }
                throw new IllegalArgumentException("Unsupported declaration type: " + element + " " + JetPsiUtil.getElementTextWithContext(element));
            }
        }, null);
        if (result == null) {
            throw new IllegalStateException("No descriptor resolved for " + declaration + " " + declaration.getText());
        }
        DeclarationDescriptor declarationDescriptor = result;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "resolveToDescriptor"));
        }
        return declarationDescriptor;
    }

    @NotNull
    public Name resolveClassifierAlias(@NotNull FqName packageName, @NotNull Name alias) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "resolveClassifierAlias"));
        }
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "resolveClassifierAlias"));
        }
        Name actualName = this.classifierAliases.fun(packageName.child(alias));
        if (actualName == null) {
            Name name = alias;
            if (name == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "resolveClassifierAlias"));
            }
            return name;
        }
        Name name = actualName;
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSession", "resolveClassifierAlias"));
        }
        return name;
    }

    @Override
    public void forceResolveAll() {
        this.rootPackage.acceptVoid((DeclarationDescriptorVisitor<Void, Void>)new DeclarationDescriptorVisitorEmptyBodies<Void, Void>(){

            @Override
            public Void visitTypeParameterDescriptor(TypeParameterDescriptor descriptor, Void data2) {
                ForceResolveUtil.forceResolveAllContents(descriptor);
                return null;
            }

            @Override
            public Void visitNamespaceDescriptor(NamespaceDescriptor descriptor, Void data2) {
                ForceResolveUtil.forceResolveAllContents(descriptor);
                return null;
            }

            @Override
            public Void visitClassDescriptor(ClassDescriptor descriptor, Void data2) {
                ForceResolveUtil.forceResolveAllContents(descriptor);
                return null;
            }

            @Override
            public Void visitModuleDeclaration(ModuleDescriptor descriptor, Void data2) {
                ForceResolveUtil.forceResolveAllContents(descriptor);
                return null;
            }

            @Override
            public Void visitScriptDescriptor(ScriptDescriptor scriptDescriptor, Void data2) {
                ForceResolveUtil.forceResolveAllContents(scriptDescriptor);
                return null;
            }
        });
    }
}

