/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class FilteringScope
implements JetScope {
    @NotNull
    private final JetScope workerScope;
    @NotNull
    private final Predicate<DeclarationDescriptor> predicate;

    public FilteringScope(@NotNull JetScope workerScope, @NotNull Predicate<DeclarationDescriptor> predicate) {
        if (workerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workerScope", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "<init>"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "<init>"));
        }
        this.workerScope = workerScope;
        this.predicate = predicate;
    }

    @Override
    @NotNull
    public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getFunctions"));
        }
        Collection<DeclarationDescriptor> collection = Collections2.filter(this.workerScope.getFunctions(name), this.predicate);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getFunctions"));
        }
        return collection;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = this.workerScope.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Nullable
    private <D extends DeclarationDescriptor> D filterDescriptor(@Nullable D descriptor) {
        return descriptor != null && this.predicate.apply(descriptor) ? (D)descriptor : null;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getNamespace"));
        }
        return this.filterDescriptor(this.workerScope.getNamespace(name));
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getClassifier"));
        }
        return this.filterDescriptor(this.workerScope.getClassifier(name));
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getObjectDescriptor"));
        }
        return this.filterDescriptor(this.workerScope.getObjectDescriptor(name));
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> getObjectDescriptors() {
        Collection<DeclarationDescriptor> collection = Collections2.filter(this.workerScope.getObjectDescriptors(), this.predicate);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getObjectDescriptors"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getProperties"));
        }
        Collection<DeclarationDescriptor> collection = Collections2.filter(this.workerScope.getProperties(name), this.predicate);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getProperties"));
        }
        return collection;
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getLocalVariable"));
        }
        return this.filterDescriptor(this.workerScope.getLocalVariable(name));
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        Collection<DeclarationDescriptor> collection = Collections2.filter(this.workerScope.getAllDescriptors(), this.predicate);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getAllDescriptors"));
        }
        return collection;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        List<ReceiverParameterDescriptor> list2 = this.workerScope.getImplicitReceiversHierarchy();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getImplicitReceiversHierarchy"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getDeclarationsByLabel"));
        }
        Collection<DeclarationDescriptor> collection = Collections2.filter(this.workerScope.getDeclarationsByLabel(labelName), this.predicate);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getDeclarationsByLabel"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        Collection<DeclarationDescriptor> collection = Collections2.filter(this.workerScope.getOwnDeclaredDescriptors(), this.predicate);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/FilteringScope", "getOwnDeclaredDescriptors"));
        }
        return collection;
    }
}

